/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import org.metafacture.biblio.iso2709.Iso646ByteBuffer;
import org.metafacture.biblio.iso2709.Iso646Constants;
import org.metafacture.biblio.iso2709.RecordFormat;
import org.metafacture.framework.FormatException;

final class DirectoryBuilder {
    private static final int RADIX = 10;
    private final Iso646ByteBuffer buffer = new Iso646ByteBuffer(99974);
    private final int fieldStartLength;
    private final int fieldLengthLength;
    private final int implDefinedPartLength;
    private final int entryLength;
    private final int maxFieldStart;
    private final int maxFieldLength;

    DirectoryBuilder(RecordFormat format) {
        this.fieldStartLength = format.getFieldStartLength();
        this.fieldLengthLength = format.getFieldLengthLength();
        this.implDefinedPartLength = format.getImplDefinedPartLength();
        this.entryLength = 3 + this.fieldStartLength + this.fieldLengthLength + this.implDefinedPartLength;
        this.maxFieldStart = this.calculateMaxValue(this.fieldStartLength);
        this.maxFieldLength = this.calculateMaxValue(this.fieldLengthLength);
    }

    private int calculateMaxValue(int digits) {
        assert (digits >= 0);
        int maxValue = 1;
        for (int i = 0; i < digits; ++i) {
            maxValue *= 10;
        }
        return maxValue - 1;
    }

    void addEntries(char[] tag, char[] implDefinedPart, int fieldStart, int fieldEnd) {
        assert (tag.length == 3);
        assert (implDefinedPart.length == this.implDefinedPartLength);
        assert (fieldStart >= 0);
        assert (fieldEnd >= fieldStart);
        this.checkDirectoryCapacity(fieldStart, fieldEnd);
        this.checkFieldFitsInAddressSpace(fieldStart, fieldEnd);
        this.writeEntries(tag, implDefinedPart, fieldStart, fieldEnd);
    }

    private void checkDirectoryCapacity(int fieldStart, int fieldEnd) {
        int fieldLength = fieldEnd - fieldStart;
        int numberOfEntries = fieldLength / this.maxFieldLength + (fieldLength % this.maxFieldLength == 0 ? 0 : 1);
        if (numberOfEntries * this.entryLength > this.buffer.getFreeSpace()) {
            throw new FormatException("directory does not have enough free space for directory entry");
        }
    }

    private void checkFieldFitsInAddressSpace(int fieldStart, int fieldEnd) {
        int fieldLength = fieldEnd - fieldStart;
        int lastPartLength = fieldLength % this.maxFieldLength;
        int lastPartStart = fieldEnd - lastPartLength;
        if (lastPartStart > this.maxFieldStart) {
            throw new FormatException("field is too long");
        }
    }

    private void writeEntries(char[] tag, char[] implDefinedPart, int fieldStart, int fieldEnd) {
        int remainingLength = fieldEnd - fieldStart;
        int partStart = fieldStart;
        while (remainingLength > this.maxFieldLength) {
            this.writeEntry(tag, implDefinedPart, partStart, 0);
            remainingLength -= this.maxFieldLength;
            partStart += this.maxFieldLength;
        }
        this.writeEntry(tag, implDefinedPart, partStart, remainingLength);
    }

    private void writeEntry(char[] tag, char[] implDefinedPart, int partStart, int partLength) {
        this.buffer.writeChars(tag);
        this.buffer.writeInt(partLength, this.fieldLengthLength);
        this.buffer.writeInt(partStart, this.fieldStartLength);
        this.buffer.writeChars(implDefinedPart);
    }

    void reset() {
        this.buffer.setWritePosition(0);
    }

    int length() {
        return this.buffer.getWritePosition() + 1;
    }

    void copyToBuffer(byte[] destBuffer, int fromIndex) {
        int directoryLength = this.buffer.getWritePosition();
        System.arraycopy(this.buffer.getByteArray(), 0, destBuffer, fromIndex, directoryLength);
        int directoryEnd = fromIndex + directoryLength;
        destBuffer[directoryEnd] = 30;
    }

    public String toString() {
        return this.buffer.stringAt(0, this.buffer.getWritePosition(), Iso646Constants.CHARSET);
    }
}

