/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import org.metafacture.biblio.iso2709.Iso646ByteBuffer;
import org.metafacture.biblio.iso2709.RecordFormat;

class DirectoryEntry {
    private final Iso646ByteBuffer buffer;
    private final int directoryEnd;
    private final int fieldLengthLength;
    private final int fieldStartLength;
    private final int implDefinedPartLength;
    private final int entryLength;
    private int currentPosition;

    DirectoryEntry(Iso646ByteBuffer buffer, RecordFormat recordFormat, int baseAddress) {
        assert (buffer != null);
        assert (baseAddress >= 25);
        assert (baseAddress <= 99998);
        this.buffer = buffer;
        this.directoryEnd = baseAddress - 1;
        this.fieldLengthLength = recordFormat.getFieldLengthLength();
        this.fieldStartLength = recordFormat.getFieldStartLength();
        this.implDefinedPartLength = recordFormat.getImplDefinedPartLength();
        this.entryLength = 3 + this.fieldLengthLength + this.fieldStartLength + this.implDefinedPartLength;
        this.rewind();
    }

    void rewind() {
        this.currentPosition = 24;
    }

    void gotoNext() {
        assert (this.currentPosition < this.directoryEnd);
        this.currentPosition += this.entryLength;
    }

    boolean endOfDirectoryReached() {
        return this.currentPosition >= this.directoryEnd;
    }

    char[] getTag() {
        assert (this.currentPosition < this.directoryEnd);
        return this.buffer.charsAt(this.currentPosition, 3);
    }

    int getFieldLength() {
        assert (this.currentPosition < this.directoryEnd);
        int fieldLengthStart = this.currentPosition + 3;
        return this.buffer.parseIntAt(fieldLengthStart, this.fieldLengthLength);
    }

    int getFieldStart() {
        assert (this.currentPosition < this.directoryEnd);
        int fieldStartStart = this.currentPosition + 3 + this.fieldLengthLength;
        return this.buffer.parseIntAt(fieldStartStart, this.fieldStartLength);
    }

    char[] getImplDefinedPart() {
        assert (this.currentPosition < this.directoryEnd);
        int implDefinedPartStart = this.currentPosition + 3 + this.fieldLengthLength + this.fieldStartLength;
        return this.buffer.charsAt(implDefinedPartStart, this.implDefinedPartLength);
    }

    boolean isRecordIdField() {
        char[] tag = this.getTag();
        return tag[0] == '0' && tag[1] == '0' && tag[2] == '1';
    }

    boolean isReferenceField() {
        char[] tag = this.getTag();
        return tag[0] == '0' && tag[1] == '0';
    }

    boolean isContinuedField() {
        return this.getFieldLength() == 0;
    }

    public String toString() {
        if (this.endOfDirectoryReached()) {
            return "@END-OF-DIRECTORY";
        }
        return String.valueOf(this.getTag()) + String.valueOf(this.getFieldLength()) + String.valueOf(this.getFieldStart()) + String.valueOf(this.getImplDefinedPart());
    }
}

