/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.metafacture.biblio.iso2709.Iso646ByteBuffer;
import org.metafacture.biblio.iso2709.RecordFormat;
import org.metafacture.framework.FormatException;

final class FieldsBuilder {
    private static final int NO_MARKER_SET = -1;
    private static final char[] NO_INDICATORS = new char[0];
    private final Iso646ByteBuffer buffer;
    private final int identifierLength;
    private Charset charset = StandardCharsets.UTF_8;
    private int undoMarker = -1;
    private boolean inField;

    FieldsBuilder(RecordFormat format, int maxSize) {
        this.buffer = new Iso646ByteBuffer(maxSize);
        this.identifierLength = format.getIdentifierLength();
    }

    void setCharset(Charset charset) {
        assert (charset != null);
        this.charset = charset;
    }

    Charset getCharset() {
        return this.charset;
    }

    int startField() {
        return this.startField(NO_INDICATORS);
    }

    int startField(char[] indicators) {
        assert (!this.inField);
        this.checkCapacity(indicators.length + 1);
        this.inField = true;
        this.undoMarker = this.buffer.getWritePosition();
        this.buffer.writeChars(indicators);
        return this.undoMarker;
    }

    int endField() {
        assert (this.inField);
        this.checkCapacity(1);
        this.inField = false;
        this.buffer.writeByte((byte)30);
        return this.buffer.getWritePosition();
    }

    void appendValue(String value) {
        assert (this.inField);
        byte[] bytes = value.getBytes(this.charset);
        this.checkCapacity(bytes.length + 1);
        this.buffer.writeBytes(bytes);
    }

    void appendSubfield(char[] identifier, String value) {
        assert (this.inField);
        byte[] bytes = value.getBytes(this.charset);
        this.checkCapacity(bytes.length + this.identifierLength + 1);
        if (this.identifierLength > 0) {
            this.buffer.writeByte((byte)31);
            this.buffer.writeChars(identifier);
        }
        this.buffer.writeBytes(bytes);
    }

    private void checkCapacity(int dataLength) {
        if (dataLength > this.buffer.getFreeSpace()) {
            throw new FormatException("not enough space for field");
        }
    }

    void undoLastField() {
        assert (this.undoMarker != -1);
        this.buffer.setWritePosition(this.undoMarker);
        this.undoMarker = -1;
    }

    void reset() {
        this.buffer.setWritePosition(0);
        this.undoMarker = -1;
        this.inField = false;
    }

    int length() {
        assert (!this.inField);
        return this.buffer.getWritePosition() + 1;
    }

    void copyToBuffer(byte[] destBuffer, int fromIndex) {
        assert (!this.inField);
        int fieldLength = this.buffer.getWritePosition();
        System.arraycopy(this.buffer.getByteArray(), 0, destBuffer, fromIndex, fieldLength);
        int fieldsEnd = fromIndex + fieldLength;
        destBuffer[fieldsEnd] = 29;
    }

    public String toString() {
        return this.buffer.stringAt(0, this.buffer.getWritePosition(), this.charset);
    }
}

