/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import java.nio.charset.Charset;
import org.metafacture.biblio.iso2709.Iso646Constants;
import org.metafacture.framework.FormatException;

final class Iso646ByteBuffer {
    private static final int RADIX = 10;
    private final byte[] byteArray;
    private int writePosition;

    Iso646ByteBuffer(int size) {
        this(new byte[size]);
    }

    Iso646ByteBuffer(byte[] byteArray) {
        assert (byteArray != null);
        this.byteArray = byteArray;
    }

    byte[] getByteArray() {
        return this.byteArray;
    }

    int getLength() {
        return this.byteArray.length;
    }

    int getFreeSpace() {
        return this.byteArray.length - this.writePosition;
    }

    void setWritePosition(int writePosition) {
        assert (0 <= writePosition && writePosition <= this.byteArray.length);
        this.writePosition = writePosition;
    }

    int getWritePosition() {
        return this.writePosition;
    }

    int distanceTo(byte byteValue, int fromIndex) {
        int index;
        assert (0 <= fromIndex && fromIndex < this.byteArray.length);
        for (index = fromIndex; index < this.byteArray.length && byteValue != this.byteArray[index]; ++index) {
        }
        return index - fromIndex;
    }

    int distanceTo(byte[] bytes, int fromIndex) {
        int index;
        assert (0 <= fromIndex && fromIndex < this.byteArray.length);
        for (index = fromIndex; index < this.byteArray.length && !this.containsByte(bytes, this.byteArray[index]); ++index) {
        }
        return index - fromIndex;
    }

    private boolean containsByte(byte[] haystack, byte needle) {
        for (byte byteValue : haystack) {
            if (byteValue != needle) continue;
            return true;
        }
        return false;
    }

    String stringAt(int fromIndex, int length, Charset charset) {
        return new String(this.byteArray, fromIndex, length, charset);
    }

    char charAt(int index) {
        return this.byteToChar(index);
    }

    char[] charsAt(int fromIndex, int length) {
        assert (length >= 0);
        assert (0 <= fromIndex && fromIndex + length <= this.byteArray.length);
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = this.byteToChar(fromIndex + i);
        }
        return chars;
    }

    private char byteToChar(int index) {
        byte value = this.byteArray[index];
        if (value < 0) {
            throw new FormatException("Invalid character code found at index " + index);
        }
        return (char)value;
    }

    byte byteAt(int index) {
        return this.byteArray[index];
    }

    int parseIntAt(int index) {
        return this.byteToDigit(index);
    }

    int parseIntAt(int fromIndex, int length) {
        assert (length >= 0);
        assert (0 <= fromIndex && fromIndex + length <= this.byteArray.length);
        int multiplyMax = 0xCCCCCCC;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int digit;
            if (result > 0xCCCCCCC) {
                this.throwNumberIsToLargeException(fromIndex);
            }
            if ((result *= 10) > Integer.MAX_VALUE - (digit = this.byteToDigit(fromIndex + i))) {
                this.throwNumberIsToLargeException(fromIndex);
            }
            result += digit;
        }
        return result;
    }

    private int byteToDigit(int index) {
        byte digit = this.byteArray[index];
        if (digit < 48 || 57 < digit) {
            throw new NumberFormatException("digit expected at index " + index + " but got 0x" + Integer.toHexString(digit));
        }
        return digit - 48;
    }

    private void throwNumberIsToLargeException(int index) {
        throw new NumberFormatException("number starting at index " + index + " is too large");
    }

    void writeChar(char charValue) {
        assert (charValue <= '\u007f');
        this.byteArray[this.writePosition] = (byte)charValue;
        ++this.writePosition;
    }

    void writeChars(char[] chars) {
        assert (this.writePosition + chars.length <= this.byteArray.length);
        for (char charValue : chars) {
            this.writeChar(charValue);
        }
    }

    void writeByte(byte value) {
        this.byteArray[this.writePosition] = value;
        ++this.writePosition;
    }

    void writeBytes(byte[] array) {
        System.arraycopy(array, 0, this.byteArray, this.writePosition, array.length);
        this.writePosition += array.length;
    }

    void writeInt(int value) {
        assert (0 <= value && value < 10);
        this.byteArray[this.writePosition] = (byte)(48 + value);
        ++this.writePosition;
    }

    void writeInt(int value, int digits) {
        assert (value >= 0);
        assert (digits >= 0);
        assert (this.writePosition + digits <= this.byteArray.length);
        int head = value;
        for (int i = this.writePosition + digits - 1; i >= this.writePosition; --i) {
            this.byteArray[i] = (byte)(48 + head % 10);
            head /= 10;
        }
        assert (head == 0);
        this.writePosition += digits;
    }

    public String toString() {
        return this.stringAt(0, this.byteArray.length, Iso646Constants.CHARSET);
    }
}

