/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import org.metafacture.biblio.iso2709.Iso646ByteBuffer;
import org.metafacture.biblio.iso2709.Iso646Constants;
import org.metafacture.biblio.iso2709.RecordFormat;

class Label {
    private final Iso646ByteBuffer buffer;

    Label(Iso646ByteBuffer buffer) {
        int bufferLength = buffer.getLength();
        assert (bufferLength >= 24);
        this.buffer = buffer;
    }

    RecordFormat getRecordFormat() {
        return RecordFormat.create().withIndicatorLength(this.getIndicatorLength()).withIdentifierLength(this.getIdentifierLength()).withFieldLengthLength(this.getFieldLengthLength()).withFieldStartLength(this.getFieldStartLength()).withImplDefinedPartLength(this.getImplDefinedPartLength()).build();
    }

    int getRecordLength() {
        return this.buffer.parseIntAt(0, 5);
    }

    char getRecordStatus() {
        return this.buffer.charAt(5);
    }

    char[] getImplCodes() {
        return this.buffer.charsAt(6, 4);
    }

    int getIndicatorLength() {
        return this.buffer.parseIntAt(10);
    }

    int getIdentifierLength() {
        return this.buffer.parseIntAt(11);
    }

    int getBaseAddress() {
        return this.buffer.parseIntAt(12, 5);
    }

    char[] getSystemChars() {
        return this.buffer.charsAt(17, 3);
    }

    int getFieldLengthLength() {
        return this.buffer.parseIntAt(20);
    }

    int getFieldStartLength() {
        return this.buffer.parseIntAt(21);
    }

    int getImplDefinedPartLength() {
        return this.buffer.parseIntAt(22);
    }

    char getReservedChar() {
        return this.buffer.charAt(23);
    }

    public String toString() {
        return this.buffer.stringAt(0, 24, Iso646Constants.CHARSET);
    }
}

