/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import java.util.Arrays;
import org.metafacture.biblio.iso2709.Iso646ByteBuffer;
import org.metafacture.biblio.iso2709.Iso646Constants;
import org.metafacture.biblio.iso2709.RecordFormat;

class LabelBuilder {
    private static final char DEFAULT_RECORD_STATUS = ' ';
    private static final char[] DEFAULT_IMPL_CODES = new char[]{' ', ' ', ' ', ' '};
    private static final char[] DEFAULT_SYSTEM_CHARS = new char[]{' ', ' ', ' '};
    private static final char DEFAULT_RESERVED_CHAR = ' ';
    private final Iso646ByteBuffer buffer = new Iso646ByteBuffer(24);
    private final byte[] defaultLabel;

    LabelBuilder(RecordFormat recordFormat) {
        this.defaultLabel = this.buildDefaultLabel(recordFormat);
    }

    private byte[] buildDefaultLabel(RecordFormat recordFormat) {
        this.writeRecordFormatToLabel(recordFormat);
        this.setRecordLength(26);
        this.setRecordStatus(' ');
        this.setImplCodes(DEFAULT_IMPL_CODES);
        this.setBaseAddress(25);
        this.setSystemChars(DEFAULT_SYSTEM_CHARS);
        this.setReservedChar(' ');
        return Arrays.copyOf(this.buffer.getByteArray(), this.buffer.getLength());
    }

    private void writeRecordFormatToLabel(RecordFormat recordFormat) {
        this.buffer.setWritePosition(10);
        this.buffer.writeInt(recordFormat.getIndicatorLength());
        this.buffer.setWritePosition(11);
        this.buffer.writeInt(recordFormat.getIdentifierLength());
        this.buffer.setWritePosition(20);
        this.buffer.writeInt(recordFormat.getFieldLengthLength());
        this.buffer.setWritePosition(21);
        this.buffer.writeInt(recordFormat.getFieldStartLength());
        this.buffer.setWritePosition(22);
        this.buffer.writeInt(recordFormat.getImplDefinedPartLength());
    }

    void setRecordLength(int recordLength) {
        assert (recordLength >= 26);
        assert (recordLength <= 99999);
        this.buffer.setWritePosition(0);
        this.buffer.writeInt(recordLength, 5);
    }

    void setRecordStatus(char recordStatus) {
        this.buffer.setWritePosition(5);
        this.buffer.writeChar(recordStatus);
    }

    void setImplCodes(char[] implCodes) {
        assert (implCodes.length == 4);
        this.buffer.setWritePosition(6);
        this.buffer.writeChars(implCodes);
    }

    void setImplCode(int index, char value) {
        assert (0 <= index && index < 4);
        this.buffer.setWritePosition(6 + index);
        this.buffer.writeChar(value);
    }

    void setBaseAddress(int baseAddress) {
        assert (baseAddress >= 25);
        assert (baseAddress <= 99998);
        this.buffer.setWritePosition(12);
        this.buffer.writeInt(baseAddress, 5);
    }

    void setSystemChars(char[] systemChars) {
        assert (systemChars.length == 3);
        this.buffer.setWritePosition(17);
        this.buffer.writeChars(systemChars);
    }

    void setSystemChar(int index, char value) {
        assert (0 <= index && index < 3);
        this.buffer.setWritePosition(17 + index);
        this.buffer.writeChar(value);
    }

    void setReservedChar(char reservedChar) {
        this.buffer.setWritePosition(23);
        this.buffer.writeChar(reservedChar);
    }

    void reset() {
        this.buffer.setWritePosition(0);
        this.buffer.writeBytes(this.defaultLabel);
    }

    void copyToBuffer(byte[] destBuffer) {
        System.arraycopy(this.buffer.getByteArray(), 0, destBuffer, 0, this.buffer.getLength());
    }

    public String toString() {
        return this.buffer.stringAt(0, this.buffer.getLength(), Iso646Constants.CHARSET);
    }
}

