/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.metafacture.biblio.iso2709.DirectoryEntry;
import org.metafacture.biblio.iso2709.FieldHandler;
import org.metafacture.biblio.iso2709.Iso646ByteBuffer;
import org.metafacture.biblio.iso2709.Label;
import org.metafacture.biblio.iso2709.RecordFormat;
import org.metafacture.commons.Require;
import org.metafacture.framework.FormatException;

public final class Record {
    private static final int RECORD_ID_MISSING = -1;
    private static final char[] EMPTY_IDENTIFIER = new char[0];
    private static final byte[] DATA_SEPARATORS = new byte[]{30, 31};
    private final Iso646ByteBuffer buffer;
    private final Label label;
    private final DirectoryEntry directoryEntry;
    private final int baseAddress;
    private final int indicatorLength;
    private final int identifierLength;
    private final int recordIdFieldStart;
    private Charset charset = StandardCharsets.UTF_8;
    private FieldHandler fieldHandler;

    public Record(byte[] recordData) {
        Require.notNull((Object)recordData);
        this.checkRecordDataLength(recordData);
        this.buffer = new Iso646ByteBuffer(recordData);
        this.label = new Label(this.buffer);
        this.baseAddress = this.label.getBaseAddress();
        this.checkBaseAddress();
        this.directoryEntry = new DirectoryEntry(this.buffer, this.label.getRecordFormat(), this.baseAddress);
        this.indicatorLength = this.label.getIndicatorLength();
        this.identifierLength = this.label.getIdentifierLength();
        this.recordIdFieldStart = this.findRecordIdFieldStart();
    }

    private void checkRecordDataLength(byte[] recordData) {
        if (recordData.length < 26) {
            throw new FormatException("record is too short");
        }
    }

    private void checkBaseAddress() {
        if (this.baseAddress < 25 || this.baseAddress > this.buffer.getLength() - 1) {
            throw new FormatException("base address is out of range");
        }
    }

    private int findRecordIdFieldStart() {
        this.directoryEntry.rewind();
        while (!this.directoryEntry.endOfDirectoryReached()) {
            if (this.directoryEntry.isRecordIdField()) {
                return this.directoryEntry.getFieldStart();
            }
            this.directoryEntry.gotoNext();
        }
        return -1;
    }

    public RecordFormat getRecordFormat() {
        return this.label.getRecordFormat();
    }

    public char getRecordStatus() {
        return this.label.getRecordStatus();
    }

    public char[] getImplCodes() {
        return this.label.getImplCodes();
    }

    public char[] getSystemChars() {
        return this.label.getSystemChars();
    }

    public char getReservedChar() {
        return this.label.getReservedChar();
    }

    public void setCharset(Charset charset) {
        this.charset = (Charset)Require.notNull((Object)charset);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getRecordId() {
        if (this.recordIdFieldStart == -1) {
            return null;
        }
        int dataStart = this.baseAddress + this.recordIdFieldStart;
        int dataLength = this.buffer.distanceTo(DATA_SEPARATORS, dataStart);
        return this.buffer.stringAt(dataStart, dataLength, this.charset);
    }

    public String getLabel() {
        return this.label.toString();
    }

    public void processFields(FieldHandler currentFieldHandler) {
        this.fieldHandler = (FieldHandler)Require.notNull((Object)currentFieldHandler);
        boolean continuedField = false;
        this.directoryEntry.rewind();
        while (!this.directoryEntry.endOfDirectoryReached()) {
            if (continuedField) {
                this.fieldHandler.additionalImplDefinedPart(this.directoryEntry.getImplDefinedPart());
            } else {
                this.processField();
            }
            continuedField = this.directoryEntry.isContinuedField();
            this.directoryEntry.gotoNext();
        }
        this.fieldHandler = null;
    }

    private void processField() {
        if (this.directoryEntry.isReferenceField()) {
            this.processReferenceField();
        } else {
            this.processDataField();
        }
    }

    private void processReferenceField() {
        int fieldStart = this.baseAddress + this.directoryEntry.getFieldStart();
        int fieldLength = this.buffer.distanceTo((byte)30, fieldStart);
        String value = this.buffer.stringAt(fieldStart, fieldLength, this.charset);
        this.fieldHandler.referenceField(this.directoryEntry.getTag(), this.directoryEntry.getImplDefinedPart(), value);
    }

    private void processDataField() {
        int fieldStart = this.baseAddress + this.directoryEntry.getFieldStart();
        char[] indicators = this.buffer.charsAt(fieldStart, this.indicatorLength);
        this.fieldHandler.startDataField(this.directoryEntry.getTag(), this.directoryEntry.getImplDefinedPart(), indicators);
        this.processDataValues(fieldStart + this.indicatorLength);
        this.fieldHandler.endDataField();
    }

    private void processDataValues(int fromIndex) {
        int start = fromIndex;
        while (this.buffer.byteAt(start) != 30) {
            start = this.processDataValue(start);
        }
    }

    private int processDataValue(int fromIndex) {
        char[] identifier = this.getIdentifier(fromIndex);
        int dataStart = fromIndex + this.identifierLength;
        int dataLength = this.buffer.distanceTo(DATA_SEPARATORS, dataStart);
        String data = this.buffer.stringAt(dataStart, dataLength, this.charset);
        this.fieldHandler.data(identifier, data);
        return dataStart + dataLength;
    }

    private char[] getIdentifier(int fromIndex) {
        if (this.identifierLength > 1) {
            return this.buffer.charsAt(fromIndex + 1, this.identifierLength - 1);
        }
        return EMPTY_IDENTIFIER;
    }
}

