/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.metafacture.biblio.iso2709.DirectoryBuilder;
import org.metafacture.biblio.iso2709.FieldsBuilder;
import org.metafacture.biblio.iso2709.LabelBuilder;
import org.metafacture.biblio.iso2709.RecordFormat;
import org.metafacture.commons.Require;
import org.metafacture.framework.FormatException;

public final class RecordBuilder {
    private static final char[] EMPTY_IDENTIFIER = new char[0];
    private static final char[] ID_FIELD_TAG = new char[]{'0', '0', '1'};
    private static final Pattern REFERENCE_FIELD_TAG_PATTERN = Pattern.compile("^00[1-9a-zA-Z]$");
    private static final Pattern DATA_FIELD_TAG_PATTERN = Pattern.compile("^(0[1-9a-zA-Z][0-9a-zA-Z])|([1-9a-zA-Z][0-9a-zA-Z]{2})$");
    private final LabelBuilder label;
    private final DirectoryBuilder directory;
    private final FieldsBuilder fields;
    private final int indicatorLength;
    private final int identifierLength;
    private final int implDefinedPartLength;
    private final char[] defaultImplDefinedPart;
    private final char[] defaultIndicators;
    private final char[] defaultIdentifier;
    private final char[] tag = new char[3];
    private final char[] implDefinedPart;
    private AppendState appendState;
    private int fieldStart;

    public RecordBuilder(RecordFormat recordFormat) {
        Require.notNull((Object)recordFormat);
        this.label = new LabelBuilder(recordFormat);
        this.directory = new DirectoryBuilder(recordFormat);
        this.fields = new FieldsBuilder(recordFormat, 99974);
        this.indicatorLength = recordFormat.getIndicatorLength();
        this.identifierLength = recordFormat.getIdentifierLength();
        this.implDefinedPartLength = recordFormat.getImplDefinedPartLength();
        this.defaultImplDefinedPart = this.arrayOfNSpaceChars(this.implDefinedPartLength);
        this.defaultIndicators = this.arrayOfNSpaceChars(this.indicatorLength);
        this.defaultIdentifier = this.identifierLength > 1 ? this.arrayOfNSpaceChars(this.identifierLength - 1) : EMPTY_IDENTIFIER;
        this.implDefinedPart = new char[this.implDefinedPartLength];
        this.appendState = AppendState.ID_FIELD;
    }

    private char[] arrayOfNSpaceChars(int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, ' ');
        return chars;
    }

    public void setCharset(Charset charset) {
        this.fields.setCharset((Charset)Require.notNull((Object)charset));
    }

    public Charset getCharset() {
        return this.fields.getCharset();
    }

    public void setRecordStatus(char recordStatus) {
        this.require7BitAscii(recordStatus);
        this.label.setRecordStatus(recordStatus);
    }

    public void setImplCodes(char[] implCodes) {
        Require.notNull((Object)implCodes);
        Require.that((implCodes.length == 4 ? 1 : 0) != 0);
        this.require7BitAscii(implCodes);
        this.label.setImplCodes(implCodes);
    }

    public void setImplCode(int index, char implCode) {
        Require.that((0 <= index && index < 4 ? 1 : 0) != 0);
        this.require7BitAscii(implCode);
        this.label.setImplCode(index, implCode);
    }

    public void setSystemChars(char[] systemChars) {
        Require.notNull((Object)systemChars);
        Require.that((systemChars.length == 3 ? 1 : 0) != 0);
        this.require7BitAscii(systemChars);
        this.label.setSystemChars(systemChars);
    }

    public void setSystemChar(int index, char systemChar) {
        Require.that((0 <= index && index < 3 ? 1 : 0) != 0);
        this.require7BitAscii(systemChar);
        this.label.setSystemChar(index, systemChar);
    }

    public void setReservedChar(char reservedChar) {
        this.require7BitAscii(reservedChar);
        this.label.setReservedChar(reservedChar);
    }

    public void appendIdentifierField(String value) {
        this.appendIdentifierField(this.defaultImplDefinedPart, value);
    }

    public void appendIdentifierField(char[] currentImplDefinedPart, String value) {
        this.requireNotInDataField();
        this.requireNotAppendingReferenceFields();
        this.requireNotAppendingDataFields();
        if (this.appendState != AppendState.ID_FIELD) {
            throw new IllegalStateException("no id field allowed");
        }
        this.appendReferenceField(ID_FIELD_TAG, currentImplDefinedPart, value);
    }

    public void appendReferenceField(char[] currentTag, String value) {
        this.appendReferenceField(currentTag, this.defaultImplDefinedPart, value);
    }

    public void appendReferenceField(char[] currentTag, char[] currentImplDefinedPart, String value) {
        this.requireNotInDataField();
        this.requireNotAppendingDataFields();
        Require.notNull((Object)currentTag);
        Require.notNull((Object)currentImplDefinedPart);
        Require.that((currentImplDefinedPart.length == this.implDefinedPartLength ? 1 : 0) != 0);
        this.require7BitAscii(currentImplDefinedPart);
        Require.notNull((Object)value);
        this.checkValidReferenceFieldTag(currentTag);
        int currentFieldStart = this.fields.startField();
        this.fields.appendValue(value);
        int fieldEnd = this.fields.endField();
        try {
            this.directory.addEntries(currentTag, currentImplDefinedPart, currentFieldStart, fieldEnd);
        }
        catch (FormatException e) {
            this.fields.undoLastField();
            throw e;
        }
        this.appendState = AppendState.REFERENCE_FIELD;
    }

    private void checkValidReferenceFieldTag(char[] currentTag) {
        if (!REFERENCE_FIELD_TAG_PATTERN.matcher(String.valueOf(currentTag)).matches()) {
            throw new FormatException("invalid tag format for reference field");
        }
    }

    public void startDataField(char[] currentTag) {
        this.startDataField(currentTag, this.defaultIndicators);
    }

    public void startDataField(char[] currentTag, char[] indicators) {
        this.startDataField(currentTag, indicators, this.defaultImplDefinedPart);
    }

    public void startDataField(char[] currentTag, char[] indicators, char[] currentImplDefinedPart) {
        this.requireNotInDataField();
        Require.notNull((Object)currentTag);
        Require.notNull((Object)indicators);
        Require.that((indicators.length == this.indicatorLength ? 1 : 0) != 0);
        this.require7BitAscii(indicators);
        Require.notNull((Object)currentImplDefinedPart);
        Require.that((currentImplDefinedPart.length == this.implDefinedPartLength ? 1 : 0) != 0);
        this.require7BitAscii(currentImplDefinedPart);
        this.checkValidDataFieldTag(currentTag);
        this.copyArray(currentTag, this.tag);
        this.copyArray(currentImplDefinedPart, this.implDefinedPart);
        this.fieldStart = this.fields.startField(indicators);
        this.appendState = AppendState.IN_DATA_FIELD;
    }

    private void checkValidDataFieldTag(char[] currentTag) {
        if (!DATA_FIELD_TAG_PATTERN.matcher(String.valueOf(currentTag)).matches()) {
            throw new FormatException("invalid tag format for data field");
        }
    }

    private void copyArray(char[] source, char[] destination) {
        System.arraycopy(source, 0, destination, 0, destination.length);
    }

    public void endDataField() {
        this.requireInDataField();
        int fieldEnd = this.fields.endField();
        this.appendState = AppendState.DATA_FIELD;
        try {
            this.directory.addEntries(this.tag, this.implDefinedPart, this.fieldStart, fieldEnd);
        }
        catch (FormatException e) {
            this.fields.undoLastField();
            throw e;
        }
    }

    public void appendSubfield(String value) {
        this.requireInDataField();
        Require.notNull((Object)value);
        this.fields.appendSubfield(this.defaultIdentifier, value);
    }

    public void appendSubfield(char[] identifier, String value) {
        this.requireInDataField();
        Require.notNull((Object)identifier);
        this.require7BitAscii(identifier);
        Require.that((identifier.length + 1 == this.identifierLength ? 1 : 0) != 0);
        Require.notNull((Object)value);
        this.fields.appendSubfield(identifier, value);
    }

    public byte[] build() {
        this.requireNotInDataField();
        int baseAddress = 24 + this.directory.length();
        int recordLength = baseAddress + this.fields.length();
        this.label.setBaseAddress(baseAddress);
        this.label.setRecordLength(recordLength);
        byte[] recordBuffer = new byte[recordLength];
        this.label.copyToBuffer(recordBuffer);
        this.directory.copyToBuffer(recordBuffer, 24);
        this.fields.copyToBuffer(recordBuffer, baseAddress);
        return recordBuffer;
    }

    private void requireNotAppendingReferenceFields() {
        if (this.appendState == AppendState.REFERENCE_FIELD) {
            throw new IllegalStateException("must not be appending reference fields");
        }
    }

    private void requireNotAppendingDataFields() {
        if (this.appendState == AppendState.DATA_FIELD) {
            throw new IllegalStateException("must not be appending data fields");
        }
    }

    private void requireInDataField() {
        if (this.appendState != AppendState.IN_DATA_FIELD) {
            throw new IllegalStateException();
        }
    }

    private void requireNotInDataField() {
        if (this.appendState == AppendState.IN_DATA_FIELD) {
            throw new IllegalStateException("must not be in field");
        }
    }

    private void require7BitAscii(char[] charArray) {
        for (char charCode : charArray) {
            this.require7BitAscii(charCode);
        }
    }

    private void require7BitAscii(char charCode) {
        Require.that((charCode <= '\u007f' ? 1 : 0) != 0);
        Require.that((charCode != '\u001f' ? 1 : 0) != 0);
        Require.that((charCode != '\u001e' ? 1 : 0) != 0);
        Require.that((charCode != '\u001d' ? 1 : 0) != 0);
    }

    public void reset() {
        this.label.reset();
        this.directory.reset();
        this.fields.reset();
        this.appendState = AppendState.ID_FIELD;
    }

    public String toString() {
        return "label: " + this.label.toString() + "\ndirectory: " + this.directory.toString() + "\nfields: " + this.fields.toString();
    }

    private static enum AppendState {
        ID_FIELD,
        REFERENCE_FIELD,
        DATA_FIELD,
        IN_DATA_FIELD;

    }
}

