/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.iso2709;

import java.util.Arrays;
import org.metafacture.commons.Require;

public final class RecordFormat {
    public static final int TAG_LENGTH = 3;
    public static final int IMPL_CODES_LENGTH = 4;
    public static final int SYSTEM_CHARS_LENGTH = 3;
    private final int indicatorLength;
    private final int identifierLength;
    private final int fieldLengthLength;
    private final int fieldStartLength;
    private final int implDefinedPartLength;

    public RecordFormat(int indicatorLength, int identifierLength, int fieldLengthLength, int fieldStartLength, int implDefinedPartLength) {
        this.indicatorLength = indicatorLength;
        this.identifierLength = identifierLength;
        this.fieldLengthLength = fieldLengthLength;
        this.fieldStartLength = fieldStartLength;
        this.implDefinedPartLength = implDefinedPartLength;
    }

    public RecordFormat(RecordFormat source) {
        Require.notNull((Object)source);
        this.indicatorLength = source.indicatorLength;
        this.identifierLength = source.identifierLength;
        this.fieldLengthLength = source.fieldLengthLength;
        this.fieldStartLength = source.fieldStartLength;
        this.implDefinedPartLength = source.implDefinedPartLength;
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder createFrom(RecordFormat source) {
        return RecordFormat.create().withIndicatorLength(source.indicatorLength).withIdentifierLength(source.identifierLength).withFieldLengthLength(source.fieldLengthLength).withFieldStartLength(source.fieldStartLength).withImplDefinedPartLength(source.implDefinedPartLength);
    }

    public int getIndicatorLength() {
        return this.indicatorLength;
    }

    public int getIdentifierLength() {
        return this.identifierLength;
    }

    public int getFieldLengthLength() {
        return this.fieldLengthLength;
    }

    public int getFieldStartLength() {
        return this.fieldStartLength;
    }

    public int getImplDefinedPartLength() {
        return this.implDefinedPartLength;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RecordFormat) {
            RecordFormat other = (RecordFormat)obj;
            return this.indicatorLength == other.indicatorLength && this.identifierLength == other.identifierLength && this.fieldLengthLength == other.fieldLengthLength && this.fieldStartLength == other.fieldStartLength && this.implDefinedPartLength == other.implDefinedPartLength;
        }
        return false;
    }

    public int hashCode() {
        int[] items = new int[]{this.indicatorLength, this.identifierLength, this.fieldLengthLength, this.fieldStartLength, this.implDefinedPartLength};
        return Arrays.hashCode(items);
    }

    public String toString() {
        return "(indicatorLength=" + this.indicatorLength + ", identifierLength=" + this.identifierLength + ", fieldLengthLength=" + this.fieldLengthLength + ", fieldStartLength= " + this.fieldStartLength + ", implDefinedPartLength=" + this.implDefinedPartLength + ")";
    }

    public static class Builder {
        private static final int RADIX = 10;
        private int indicatorLength;
        private int identifierLength;
        private int fieldLengthLength;
        private int fieldStartLength;
        private int implDefinedPartLength;

        Builder() {
        }

        public Builder withIndicatorLength(int currentIndicatorLength) {
            Require.notNegative((int)currentIndicatorLength);
            Require.that((currentIndicatorLength < 10 ? 1 : 0) != 0);
            this.indicatorLength = currentIndicatorLength;
            return this;
        }

        public Builder withIdentifierLength(int currentIdentifierLength) {
            Require.notNegative((int)currentIdentifierLength);
            Require.that((currentIdentifierLength < 10 ? 1 : 0) != 0);
            this.identifierLength = currentIdentifierLength;
            return this;
        }

        public Builder withFieldLengthLength(int currentFieldLengthLength) {
            Require.that((currentFieldLengthLength > 0 ? 1 : 0) != 0);
            Require.that((currentFieldLengthLength < 10 ? 1 : 0) != 0);
            this.fieldLengthLength = currentFieldLengthLength;
            return this;
        }

        public Builder withFieldStartLength(int currentFieldStartLength) {
            Require.that((currentFieldStartLength > 0 ? 1 : 0) != 0);
            Require.that((currentFieldStartLength < 10 ? 1 : 0) != 0);
            this.fieldStartLength = currentFieldStartLength;
            return this;
        }

        public Builder withImplDefinedPartLength(int currentImplDefinedPartLength) {
            Require.notNegative((int)currentImplDefinedPartLength);
            Require.that((currentImplDefinedPartLength < 10 ? 1 : 0) != 0);
            this.implDefinedPartLength = currentImplDefinedPartLength;
            return this;
        }

        public RecordFormat build() {
            return new RecordFormat(this.indicatorLength, this.identifierLength, this.fieldLengthLength, this.fieldStartLength, this.implDefinedPartLength);
        }
    }
}

