/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.marc21;

import org.metafacture.biblio.iso2709.FieldHandler;
import org.metafacture.biblio.iso2709.Record;
import org.metafacture.biblio.iso2709.RecordFormat;
import org.metafacture.biblio.marc21.Marc21Constants;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.FormatException;
import org.metafacture.framework.MissingIdException;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@In(value=String.class)
@Out(value=StreamReceiver.class)
@Description(value="Decodes MARC 21 records (UTF-8 encoding expected).")
@FluxCommand(value="decode-marc21")
public final class Marc21Decoder
extends DefaultObjectPipe<String, StreamReceiver> {
    public static final boolean EMIT_LEADER_AS_WHOLE = false;
    public static final boolean IGNORE_MISSING_ID = false;
    private final FieldHandler fieldHandler = new Marc21Handler();
    private boolean ignoreMissingId = false;
    private boolean emitLeaderAsWhole = false;

    public void setIgnoreMissingId(boolean ignoreMissingId) {
        this.ignoreMissingId = ignoreMissingId;
    }

    public boolean getIgnoreMissingId() {
        return this.ignoreMissingId;
    }

    public void setEmitLeaderAsWhole(boolean emitLeaderAsWhole) {
        this.emitLeaderAsWhole = emitLeaderAsWhole;
    }

    public boolean getEmitLeaderAsWhole() {
        return this.emitLeaderAsWhole;
    }

    public void process(String obj) {
        if (obj.isEmpty()) {
            return;
        }
        Record record = new Record(obj.getBytes(Marc21Constants.MARC21_CHARSET));
        record.setCharset(Marc21Constants.MARC21_CHARSET);
        this.requireMarc21RecordFormat(record.getRecordFormat());
        this.requireUTF8Encoding(record);
        ((StreamReceiver)this.getReceiver()).startRecord(this.tryGetRecordId(record));
        this.emitLeader(record);
        record.processFields(this.fieldHandler);
        ((StreamReceiver)this.getReceiver()).endRecord();
    }

    private void requireMarc21RecordFormat(RecordFormat format) {
        if (!Marc21Constants.MARC21_FORMAT.equals(format)) {
            throw new FormatException("invalid record format. Expected " + Marc21Constants.MARC21_FORMAT + " but got " + format);
        }
    }

    private void requireUTF8Encoding(Record record) {
        if (record.getImplCodes()[3] != 'a') {
            throw new FormatException("invalid record encoding. Only UTF-8 is supported");
        }
    }

    private String tryGetRecordId(Record record) {
        String id = record.getRecordId();
        if (id == null) {
            if (!this.ignoreMissingId) {
                throw new MissingIdException("record has no id");
            }
            return "";
        }
        return id;
    }

    private void emitLeader(Record record) {
        ((StreamReceiver)this.getReceiver()).startEntity("leader");
        if (this.emitLeaderAsWhole) {
            ((StreamReceiver)this.getReceiver()).literal("leader", record.getLabel());
        } else {
            char[] implCodes = record.getImplCodes();
            char[] systemChars = record.getSystemChars();
            ((StreamReceiver)this.getReceiver()).literal("status", String.valueOf(record.getRecordStatus()));
            ((StreamReceiver)this.getReceiver()).literal("type", String.valueOf(implCodes[0]));
            ((StreamReceiver)this.getReceiver()).literal("bibliographicLevel", String.valueOf(implCodes[1]));
            ((StreamReceiver)this.getReceiver()).literal("typeOfControl", String.valueOf(implCodes[2]));
            ((StreamReceiver)this.getReceiver()).literal("characterCodingScheme", String.valueOf(implCodes[3]));
            ((StreamReceiver)this.getReceiver()).literal("encodingLevel", String.valueOf(systemChars[0]));
            ((StreamReceiver)this.getReceiver()).literal("catalogingForm", String.valueOf(systemChars[1]));
            ((StreamReceiver)this.getReceiver()).literal("multipartLevel", String.valueOf(systemChars[2]));
        }
        ((StreamReceiver)this.getReceiver()).endEntity();
    }

    private final class Marc21Handler
    implements FieldHandler {
        Marc21Handler() {
        }

        @Override
        public void referenceField(char[] tag, char[] implDefinedPart, String value) {
            ((StreamReceiver)Marc21Decoder.this.getReceiver()).literal(String.valueOf(tag), value);
        }

        @Override
        public void startDataField(char[] tag, char[] implDefinedPart, char[] indicators) {
            ((StreamReceiver)Marc21Decoder.this.getReceiver()).startEntity(this.buildName(tag, indicators));
        }

        private String buildName(char[] tag, char[] indicators) {
            int nameLength = tag.length + indicators.length;
            char[] name = new char[nameLength];
            System.arraycopy(tag, 0, name, 0, tag.length);
            System.arraycopy(indicators, 0, name, tag.length, indicators.length);
            return String.valueOf(name);
        }

        @Override
        public void endDataField() {
            ((StreamReceiver)Marc21Decoder.this.getReceiver()).endEntity();
        }

        @Override
        public void additionalImplDefinedPart(char[] implDefinedPart) {
        }

        @Override
        public void data(char[] identifier, String value) {
            ((StreamReceiver)Marc21Decoder.this.getReceiver()).literal(String.valueOf(identifier[0]), value);
        }
    }
}

