/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.marc21;

import java.util.Arrays;
import org.metafacture.biblio.iso2709.RecordBuilder;
import org.metafacture.biblio.marc21.Marc21Constants;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.FormatException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@In(value=StreamReceiver.class)
@Out(value=String.class)
@Description(value="Encodes MARC21 records")
@FluxCommand(value="encode-marc21")
public final class Marc21Encoder
extends DefaultStreamPipe<ObjectReceiver<String>> {
    private static final int NAME_LENGTH = 3 + Marc21Constants.MARC21_FORMAT.getIndicatorLength();
    private final RecordBuilder builder;
    private State state = State.IN_STREAM;
    private boolean generateIdField;

    public Marc21Encoder() {
        this.builder = new RecordBuilder(Marc21Constants.MARC21_FORMAT);
        this.builder.setCharset(Marc21Constants.MARC21_CHARSET);
    }

    public void setGenerateIdField(boolean generateIdField) {
        this.generateIdField = generateIdField;
    }

    public boolean getGenerateIdField() {
        return this.generateIdField;
    }

    public void startRecord(String identifier) {
        this.builder.reset();
        this.initLeader();
        if (this.generateIdField) {
            this.builder.appendIdentifierField(identifier);
        }
        this.state = State.IN_RECORD;
    }

    private void initLeader() {
        this.builder.setRecordStatus(' ');
        this.builder.setImplCodes(new char[]{' ', ' ', ' ', ' '});
        this.builder.setSystemChars(new char[]{' ', ' ', ' '});
        this.builder.setReservedChar('0');
    }

    public void endRecord() {
        byte[] record = this.builder.build();
        ((ObjectReceiver)this.getReceiver()).process((Object)new String(record, Marc21Constants.MARC21_CHARSET));
        this.state = State.IN_STREAM;
    }

    public void startEntity(String name) {
        if (this.state != State.IN_RECORD) {
            throw new IllegalStateException("only top level entities are allowed");
        }
        if ("leader".equals(name)) {
            this.state = State.IN_LEADER_ENTITY;
        } else {
            this.startField(name);
            this.state = State.IN_FIELD_ENTITY;
        }
    }

    private void startField(String name) {
        if (name.length() != NAME_LENGTH) {
            throw new FormatException("invalid entity name: " + name);
        }
        char[] tag = new char[3];
        char[] indicators = new char[Marc21Constants.MARC21_FORMAT.getIndicatorLength()];
        name.getChars(0, tag.length, tag, 0);
        name.getChars(tag.length, name.length(), indicators, 0);
        this.builder.startDataField(tag, indicators);
    }

    public void endEntity() {
        if (this.state.equals((Object)State.IN_FIELD_ENTITY)) {
            this.builder.endDataField();
        }
        this.state = State.IN_RECORD;
    }

    public void literal(String name, String value) {
        switch (this.state) {
            case IN_FIELD_ENTITY: {
                this.builder.appendSubfield(name.toCharArray(), value);
                break;
            }
            case IN_LEADER_ENTITY: {
                if (name == "leader") {
                    this.processLeaderAsOneLiteral(value);
                    break;
                }
                this.processLeaderAsSubfields(name, value);
                break;
            }
            case IN_RECORD: {
                this.processTopLevelLiteral(name, value);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown or unexpected state: " + this.state));
            }
        }
    }

    private void processLeaderAsOneLiteral(String value) {
        if (value.length() != 24) {
            throw new FormatException("leader literal must contain 24  characters: " + value);
        }
        this.processLeaderAsSubfields("status", value.charAt(5));
        this.processLeaderAsSubfields("type", value.charAt(6));
        this.processLeaderAsSubfields("bibliographicLevel", value.charAt(7));
        this.processLeaderAsSubfields("typeOfControl", value.charAt(8));
        this.processLeaderAsSubfields("characterCodingScheme", value.charAt(9));
        this.processLeaderAsSubfields("encodingLevel", value.charAt(17));
        this.processLeaderAsSubfields("catalogingForm", value.charAt(18));
        this.processLeaderAsSubfields("multipartLevel", value.charAt(19));
    }

    private void processLeaderAsSubfields(String name, String value) {
        if (value.length() != 1) {
            throw new FormatException("literal must only contain a single character:" + name);
        }
        this.processLeaderAsSubfields(name, value.charAt(0));
    }

    private void processLeaderAsSubfields(String name, char code) {
        switch (name) {
            case "status": {
                this.requireValidCode(code, Marc21Constants.RECORD_STATUS_CODES);
                this.builder.setRecordStatus(code);
                break;
            }
            case "type": {
                this.requireValidCode(code, Marc21Constants.RECORD_TYPE_CODES);
                this.builder.setImplCode(0, code);
                break;
            }
            case "bibliographicLevel": {
                this.requireValidCode(code, Marc21Constants.BIBLIOGRAPHIC_LEVEL_CODES);
                this.builder.setImplCode(1, code);
                break;
            }
            case "typeOfControl": {
                this.requireValidCode(code, Marc21Constants.TYPE_OF_CONTROL_CODES);
                this.builder.setImplCode(2, code);
                break;
            }
            case "characterCodingScheme": {
                this.requireValidCode(code, Marc21Constants.CHARACTER_CODING_CODES);
                this.builder.setImplCode(3, code);
                break;
            }
            case "encodingLevel": {
                this.requireValidCode(code, Marc21Constants.ENCODING_LEVEL_CODES);
                this.builder.setSystemChar(0, code);
                break;
            }
            case "catalogingForm": {
                this.requireValidCode(code, Marc21Constants.CATALOGING_FORM_CODES);
                this.builder.setSystemChar(1, code);
                break;
            }
            case "multipartLevel": {
                this.requireValidCode(code, Marc21Constants.MULTIPART_LEVEL_CODES);
                this.builder.setSystemChar(2, code);
                break;
            }
            default: {
                throw new FormatException("unknown literal in leader entity: " + name);
            }
        }
    }

    private void requireValidCode(char code, char[] validCodes) {
        for (char validCode : validCodes) {
            if (validCode != code) continue;
            return;
        }
        throw new FormatException("invalid code '" + code + "'; allowed codes are: " + Arrays.toString(validCodes));
    }

    private void processTopLevelLiteral(String name, String value) {
        if ("type".equals(name)) {
            return;
        }
        if ("leader".equals(name)) {
            this.processLeaderAsOneLiteral(value);
        } else {
            this.builder.appendReferenceField(name.toCharArray(), value);
        }
    }

    protected void onResetStream() {
        this.builder.reset();
        this.state = State.IN_STREAM;
    }

    private static enum State {
        IN_STREAM,
        IN_RECORD,
        IN_FIELD_ENTITY,
        IN_LEADER_ENTITY;

    }
}

