/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.marc21;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.metafacture.biblio.marc21.Marc21Decoder;
import org.metafacture.biblio.marc21.Marc21Encoder;
import org.metafacture.commons.XmlUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.Receiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Encodes a stream into MARCXML. If you can't ensure valid MARC21 (e.g. the leader isn't correct or not set as one literal) then set the parameter `ensureCorrectMarc21Xml` to `true`.")
@In(value=StreamReceiver.class)
@Out(value=String.class)
@FluxCommand(value="encode-marcxml")
public final class MarcXmlEncoder
extends DefaultStreamPipe<ObjectReceiver<String>> {
    public static final String NAMESPACE_NAME = "marc";
    public static final String XML_ENCODING = "UTF-8";
    public static final String XML_VERSION = "1.0";
    public static final boolean PRETTY_PRINTED = true;
    public static final boolean OMIT_XML_DECLARATION = false;
    public static final boolean ENSURE_CORRECT_MARC21_XML = false;
    private static final String NAMESPACE = "http://www.loc.gov/MARC21/slim";
    private static final String NAMESPACE_PREFIX = "marc:";
    private static final String NAMESPACE_SUFFIX = ":marc";
    private static final String SCHEMA_ATTRIBUTES = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd\"";
    private static final String ATTRIBUTE_TEMPLATE = " %s=\"%s\"";
    private static final String NEW_LINE = "\n";
    private static final String INDENT = "\t";
    private static final String EMPTY = "";
    private static final String XML_DECLARATION_TEMPLATE = "<?xml version=\"%s\" encoding=\"%s\"?>";
    private static final int LEADER_ENTITY_LENGTH = 5;
    private static final int IND1_BEGIN = 3;
    private static final int IND1_END = 4;
    private static final int IND2_BEGIN = 4;
    private static final int IND2_END = 5;
    private static final int TAG_BEGIN = 0;
    private static final int TAG_END = 3;
    private final Encoder encoder = new Encoder();
    private final Marc21Encoder wrapper = new Marc21Encoder();
    private DefaultStreamPipe<ObjectReceiver<String>> pipe;

    public MarcXmlEncoder() {
        Marc21Decoder decoder = new Marc21Decoder();
        decoder.setEmitLeaderAsWhole(true);
        ((Marc21Decoder)this.wrapper.setReceiver((Receiver)decoder)).setReceiver((Receiver)this.encoder);
        this.setEnsureCorrectMarc21Xml(false);
    }

    public void setEmitNamespace(boolean emitNamespace) {
        this.encoder.setEmitNamespace(emitNamespace);
    }

    public void omitXmlDeclaration(boolean currentOmitXmlDeclaration) {
        this.encoder.omitXmlDeclaration(currentOmitXmlDeclaration);
    }

    public void setXmlVersion(String xmlVersion) {
        this.encoder.setXmlVersion(xmlVersion);
    }

    public void setXmlEncoding(String xmlEncoding) {
        this.encoder.setXmlEncoding(xmlEncoding);
    }

    public void setEnsureCorrectMarc21Xml(boolean ensureCorrectMarc21Xml) {
        this.pipe = ensureCorrectMarc21Xml ? this.wrapper : this.encoder;
    }

    public void setFormatted(boolean formatted) {
        this.encoder.setFormatted(formatted);
    }

    public void startRecord(String identifier) {
        this.pipe.startRecord(identifier);
    }

    public void endRecord() {
        this.pipe.endRecord();
    }

    public void startEntity(String name) {
        this.pipe.startEntity(name);
    }

    public void endEntity() {
        this.pipe.endEntity();
    }

    public void literal(String name, String value) {
        this.pipe.literal(name, value);
    }

    protected void onResetStream() {
        this.pipe.resetStream();
    }

    protected void onCloseStream() {
        this.pipe.closeStream();
    }

    protected void onSetReceiver() {
        this.encoder.setReceiver((Receiver)((ObjectReceiver)this.getReceiver()));
    }

    private static class Encoder
    extends DefaultStreamPipe<ObjectReceiver<String>> {
        private final StringBuilder builder = new StringBuilder();
        private final StringBuilder leaderBuilder = new StringBuilder();
        private boolean atStreamStart = true;
        private boolean omitXmlDeclaration = false;
        private String xmlVersion = "1.0";
        private String xmlEncoding = "UTF-8";
        private String currentEntity = "";
        private boolean emitNamespace = true;
        private Object[] namespacePrefix = new Object[]{"marc:"};
        private int indentationLevel;
        private boolean formatted = true;
        private int recordAttributeOffset;
        private int recordLeaderOffset;

        private Encoder() {
        }

        public void setEmitNamespace(boolean emitNamespace) {
            this.emitNamespace = emitNamespace;
            this.namespacePrefix = new Object[]{emitNamespace ? MarcXmlEncoder.NAMESPACE_PREFIX : MarcXmlEncoder.EMPTY};
        }

        public void omitXmlDeclaration(boolean currentOmitXmlDeclaration) {
            this.omitXmlDeclaration = currentOmitXmlDeclaration;
        }

        public void setXmlVersion(String xmlVersion) {
            this.xmlVersion = xmlVersion;
        }

        public void setXmlEncoding(String xmlEncoding) {
            this.xmlEncoding = xmlEncoding;
        }

        public void setFormatted(boolean formatted) {
            this.formatted = formatted;
        }

        public void startRecord(String identifier) {
            if (this.atStreamStart) {
                if (!this.omitXmlDeclaration) {
                    this.writeHeader();
                    this.prettyPrintNewLine();
                }
                this.writeTag(Tag.collection::open, this.emitNamespace ? MarcXmlEncoder.NAMESPACE_SUFFIX : MarcXmlEncoder.EMPTY, this.emitNamespace ? MarcXmlEncoder.SCHEMA_ATTRIBUTES : MarcXmlEncoder.EMPTY);
                this.prettyPrintNewLine();
                this.incrementIndentationLevel();
            }
            this.atStreamStart = false;
            this.prettyPrintIndentation();
            this.writeTag(Tag.record::open, new Object[0]);
            this.recordAttributeOffset = this.builder.length() - 1;
            this.prettyPrintNewLine();
            this.recordLeaderOffset = this.builder.length();
            this.incrementIndentationLevel();
        }

        public void endRecord() {
            this.writeLeader();
            this.decrementIndentationLevel();
            this.prettyPrintIndentation();
            this.writeTag(Tag.record::close, new Object[0]);
            this.prettyPrintNewLine();
            this.sendAndClearData();
        }

        public void startEntity(String name) {
            this.currentEntity = name;
            if (!name.equals("leader")) {
                if (name.length() != 5) {
                    String message = String.format("Entity too short.Got a string ('%s') of length %d.Expected a length of 5 (field + indicators).", name, name.length());
                    throw new MetafactureException(message);
                }
                String tag = name.substring(0, 3);
                String ind1 = name.substring(3, 4);
                String ind2 = name.substring(4, 5);
                this.prettyPrintIndentation();
                this.writeTag(Tag.datafield::open, tag, ind1, ind2);
                this.prettyPrintNewLine();
                this.incrementIndentationLevel();
            }
        }

        public void endEntity() {
            if (!this.currentEntity.equals("leader")) {
                this.decrementIndentationLevel();
                this.prettyPrintIndentation();
                this.writeTag(Tag.datafield::close, new Object[0]);
                this.prettyPrintNewLine();
            }
            this.currentEntity = MarcXmlEncoder.EMPTY;
        }

        public void literal(String name, String value) {
            if (MarcXmlEncoder.EMPTY.equals(this.currentEntity)) {
                if (name.equals("type")) {
                    if (value != null) {
                        this.builder.insert(this.recordAttributeOffset, String.format(MarcXmlEncoder.ATTRIBUTE_TEMPLATE, name, value));
                    }
                } else if (!this.appendLeader(name, value)) {
                    this.prettyPrintIndentation();
                    this.writeTag(Tag.controlfield::open, name);
                    if (value != null) {
                        this.writeEscaped(value.trim());
                    }
                    this.writeTag(Tag.controlfield::close, false);
                    this.prettyPrintNewLine();
                }
            } else if (!this.appendLeader(this.currentEntity, value)) {
                this.prettyPrintIndentation();
                this.writeTag(Tag.subfield::open, name);
                this.writeEscaped(value.trim());
                this.writeTag(Tag.subfield::close, new Object[0]);
                this.prettyPrintNewLine();
            }
        }

        protected void onResetStream() {
            if (!this.atStreamStart) {
                this.writeFooter();
            }
            this.sendAndClearData();
            this.indentationLevel = 0;
            this.atStreamStart = true;
        }

        protected void onCloseStream() {
            this.writeFooter();
            this.sendAndClearData();
        }

        private void incrementIndentationLevel() {
            ++this.indentationLevel;
        }

        private void decrementIndentationLevel() {
            --this.indentationLevel;
        }

        private void writeHeader() {
            this.writeRaw(String.format(MarcXmlEncoder.XML_DECLARATION_TEMPLATE, this.xmlVersion, this.xmlEncoding));
        }

        private void writeFooter() {
            this.writeTag(Tag.collection::close, new Object[0]);
        }

        private void writeRaw(String str) {
            this.builder.append(str);
        }

        private void writeRawLeader(String str) {
            this.builder.insert(this.recordLeaderOffset, str);
            this.recordLeaderOffset += str.length();
        }

        private boolean appendLeader(String name, String value) {
            if (name.equals("leader")) {
                this.leaderBuilder.append(value);
                return true;
            }
            return false;
        }

        private void writeEscaped(String str) {
            this.builder.append(XmlUtil.escape((String)str, (boolean)false));
        }

        private void writeLeader() {
            String leader = this.leaderBuilder.toString();
            if (this.leaderBuilder.length() > 0) {
                this.prettyPrintIndentation();
                this.writeTagLeader(Tag.leader::open);
                this.writeRawLeader(leader);
                this.writeTagLeader(Tag.leader::close);
                this.prettyPrintNewLine();
            }
        }

        private void writeTag(Function<Object[], String> function, Object ... args) {
            Object[] allArgs = Arrays.copyOf(this.namespacePrefix, this.namespacePrefix.length + args.length);
            System.arraycopy(args, 0, allArgs, this.namespacePrefix.length, args.length);
            this.writeRaw(function.apply(allArgs));
        }

        private void writeTagLeader(Function<Object[], String> function) {
            this.writeRawLeader(function.apply(this.namespacePrefix));
        }

        private void prettyPrintIndentation() {
            if (this.formatted) {
                String prefix = String.join((CharSequence)MarcXmlEncoder.EMPTY, Collections.nCopies(this.indentationLevel, MarcXmlEncoder.INDENT));
                this.builder.append(prefix);
            }
        }

        private void prettyPrintNewLine() {
            if (this.formatted) {
                this.builder.append(MarcXmlEncoder.NEW_LINE);
            }
        }

        private void sendAndClearData() {
            ((ObjectReceiver)this.getReceiver()).process((Object)this.builder.toString());
            this.builder.delete(0, this.builder.length());
            this.leaderBuilder.delete(0, this.leaderBuilder.length());
            this.recordAttributeOffset = 0;
        }
    }

    private static enum Tag {
        collection(" xmlns%s=\"http://www.loc.gov/MARC21/slim\"%s"),
        controlfield(" tag=\"%s\""),
        datafield(" tag=\"%s\" ind1=\"%s\" ind2=\"%s\""),
        leader(""),
        record(""),
        subfield(" code=\"%s\"");

        private static final String OPEN_TEMPLATE = "<%%s%s%s>";
        private static final String CLOSE_TEMPLATE = "</%%s%s>";
        private final String openTemplate;
        private final String closeTemplate;

        private Tag(String template) {
            this.openTemplate = String.format(OPEN_TEMPLATE, this.name(), template);
            this.closeTemplate = String.format(CLOSE_TEMPLATE, this.name());
        }

        public String open(Object[] args) {
            return String.format(this.openTemplate, args);
        }

        public String close(Object[] args) {
            return String.format(this.closeTemplate, args);
        }
    }
}

