/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.marc21;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.XmlReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultXmlPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Description(value="A marc xml reader")
@In(value=XmlReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="handle-marcxml")
public final class MarcXmlHandler
extends DefaultXmlPipe<StreamReceiver> {
    public static final String NAMESPACE = "http://www.loc.gov/MARC21/slim";
    private static final String SUBFIELD = "subfield";
    private static final String DATAFIELD = "datafield";
    private static final String CONTROLFIELD = "controlfield";
    private static final String RECORD = "record";
    private static final String LEADER = "leader";
    private static final String TYPE = "type";
    private String attributeMarker = "";
    private String currentTag = "";
    private String namespace = "http://www.loc.gov/MARC21/slim";
    private StringBuilder builder = new StringBuilder();

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    private boolean checkNamespace(String uri) {
        return this.namespace == null || this.namespace.equals(uri);
    }

    public void setAttributeMarker(String attributeMarker) {
        this.attributeMarker = attributeMarker;
    }

    public String getAttributeMarker() {
        return this.attributeMarker;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (SUBFIELD.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = attributes.getValue("code");
        } else if (DATAFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).startEntity(attributes.getValue("tag") + attributes.getValue("ind1") + attributes.getValue("ind2"));
        } else if (CONTROLFIELD.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = attributes.getValue("tag");
        } else if (RECORD.equals(localName) && this.checkNamespace(uri)) {
            ((StreamReceiver)this.getReceiver()).startRecord("");
            ((StreamReceiver)this.getReceiver()).literal(this.attributeMarker + TYPE, attributes.getValue(TYPE));
        } else if (LEADER.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = LEADER;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (SUBFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).literal(this.currentTag, this.builder.toString().trim());
        } else if (DATAFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).endEntity();
        } else if (CONTROLFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).literal(this.currentTag, this.builder.toString());
        } else if (RECORD.equals(localName) && this.checkNamespace(uri)) {
            ((StreamReceiver)this.getReceiver()).endRecord();
        } else if (LEADER.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).literal(this.currentTag, this.builder.toString());
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.builder.append(chars, start, length);
    }
}

