/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.pica;

enum PicaConstants {
    RECORD_MARKER('\u001d', '\n'),
    FIELD_MARKER('\u001e', '\u0000'),
    SUBFIELD_MARKER('\u001f', '$'),
    FIELD_END_MARKER('\n', '\n'),
    NO_MARKER('\u0000', '\u0000');

    private final char normalized;
    private final char nonNormalized;

    private PicaConstants(char normalized, char nonNormalized) {
        this.normalized = normalized;
        this.nonNormalized = nonNormalized;
    }

    public char get(boolean isNormalized) {
        return isNormalized ? this.normalized : this.nonNormalized;
    }

    public static PicaConstants from(boolean isNormalized, char ch) {
        for (PicaConstants value : PicaConstants.values()) {
            if (ch != (isNormalized ? value.normalized : value.nonNormalized)) continue;
            return value;
        }
        return NO_MARKER;
    }
}

