/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.pica;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.biblio.pica.PicaConstants;
import org.metafacture.biblio.pica.PicaParserContext;
import org.metafacture.biblio.pica.PicaParserState;
import org.metafacture.commons.StringUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MissingIdException;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Parses pica+ records. The parser only parses single records. A string containing multiple records must be split into individual records before passing it to PicaDecoder.")
@In(value=String.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="decode-pica")
public final class PicaDecoder
extends DefaultObjectPipe<String, StreamReceiver> {
    private static final int BUFFER_SIZE = 0x100000;
    private Matcher idFieldMatcher;
    private final StringBuilder idBuilder = new StringBuilder();
    private final PicaParserContext parserContext = new PicaParserContext();
    private char[] buffer = new char[0x100000];
    private int recordLen;
    private boolean ignoreMissingIdn;
    private boolean isNormalized;

    public PicaDecoder() {
        this(true);
    }

    public PicaDecoder(boolean normalized) {
        this.setNormalizedSerialization(normalized);
    }

    public void setNormalizedSerialization(boolean normalized) {
        this.isNormalized = normalized;
        String startMarkers = "(?:^|" + PicaConstants.FIELD_MARKER.get(this.isNormalized) + "|" + PicaConstants.FIELD_END_MARKER.get(this.isNormalized) + "|" + PicaConstants.RECORD_MARKER.get(this.isNormalized) + "|.*\n)";
        Pattern idFieldsPattern = Pattern.compile(startMarkers + "(?:003@|203@(?:/..+)?|107F)  ?(\\" + PicaConstants.SUBFIELD_MARKER.get(this.isNormalized) + "|" + PicaConstants.SUBFIELD_MARKER.get(this.isNormalized) + ")0");
        this.idFieldMatcher = idFieldsPattern.matcher("");
    }

    public void setIgnoreMissingIdn(boolean ignoreMissingIdn) {
        this.ignoreMissingIdn = ignoreMissingIdn;
    }

    public boolean getIgnoreMissingIdn() {
        return this.ignoreMissingIdn;
    }

    public void setNormalizeUTF8(boolean normalizeUTF8) {
        this.parserContext.setNormalizeUTF8(normalizeUTF8);
    }

    public boolean getNormalizeUTF8() {
        return this.parserContext.getNormalizeUTF8();
    }

    public void setSkipEmptyFields(boolean skipEmptyFields) {
        this.parserContext.setSkipEmptyFields(skipEmptyFields);
    }

    public boolean getSkipEmptyFields() {
        return this.parserContext.getSkipEmptyFields();
    }

    public void setTrimFieldNames(boolean trimFieldNames) {
        this.parserContext.setTrimFieldNames(trimFieldNames);
    }

    public boolean getTrimFieldNames() {
        return this.parserContext.getTrimFieldNames();
    }

    public void process(String record) {
        assert (!this.isClosed());
        this.buffer = StringUtil.copyToBuffer((String)record, (char[])this.buffer);
        this.recordLen = record.length();
        if (this.isRecordEmpty()) {
            return;
        }
        String id = this.extractRecordId();
        if (id == null) {
            if (!this.ignoreMissingIdn) {
                throw new MissingIdException("Record has no id");
            }
            id = "";
        }
        ((StreamReceiver)this.getReceiver()).startRecord(id);
        PicaParserState state = PicaParserState.FIELD_NAME;
        for (int i = 0; i < this.recordLen; ++i) {
            state = state.parseChar(this.buffer[i], this.parserContext, this.isNormalized);
        }
        state.endOfInput(this.parserContext);
        ((StreamReceiver)this.getReceiver()).endRecord();
    }

    protected void onSetReceiver() {
        this.parserContext.setReceiver((StreamReceiver)this.getReceiver());
    }

    protected void onResetStream() {
        this.parserContext.reset();
    }

    private boolean isRecordEmpty() {
        for (int i = 0; i < this.recordLen; ++i) {
            if (this.buffer[i] == ' ' || this.buffer[i] == '\t') continue;
            return false;
        }
        return true;
    }

    private String extractRecordId() {
        char ch;
        int idFromIndex = this.findRecordId();
        if (idFromIndex == -1) {
            return null;
        }
        this.idBuilder.setLength(0);
        for (int i = idFromIndex; i < this.recordLen && !this.isMarker(ch = this.buffer[i]); ++i) {
            this.idBuilder.append(ch);
        }
        return this.idBuilder.toString();
    }

    private int findRecordId() {
        this.idFieldMatcher.reset(new String(this.buffer, 0, this.recordLen));
        if (!this.idFieldMatcher.find()) {
            return -1;
        }
        return this.idFieldMatcher.end();
    }

    private boolean isMarker(char ch) {
        return PicaConstants.from(this.isNormalized, ch) != PicaConstants.NO_MARKER;
    }
}

