/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.pica;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.FormatException;
import org.metafacture.framework.MissingIdException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Encodes a stream in pica+ format")
@In(value=StreamReceiver.class)
@Out(value=String.class)
@FluxCommand(value="encode-pica")
public final class PicaEncoder
extends DefaultStreamPipe<ObjectReceiver<String>> {
    public static final boolean IGNORE_RECORD_ID = false;
    private static final String FIELD_DELIMITER = "\u001e";
    private static final String SUB_DELIMITER = "\u001f";
    private static final String FIELD_IDN_INTERN = "003@";
    private static final String FIELD_NAME_PATTERN_STRING = "\\d{3}.(/..)?";
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("\\d{3}.(/..)?");
    private static StringBuilder builder = new StringBuilder();
    private boolean entityOpen;
    private boolean idnControlSubField;
    private boolean ignoreRecordId = false;
    private String id;

    public void startRecord(String recordId) {
        builder.setLength(0);
        this.id = recordId;
        this.entityOpen = false;
    }

    public void setIgnoreRecordId(boolean ignoreRecordId) {
        this.ignoreRecordId = ignoreRecordId;
    }

    public boolean getIgnoreRecordId() {
        return this.ignoreRecordId;
    }

    public void startEntity(String name) {
        Matcher fieldNameMatcher = FIELD_NAME_PATTERN.matcher(name);
        if (!fieldNameMatcher.matches()) {
            throw new FormatException(name);
        }
        if (this.entityOpen) {
            throw new FormatException(name);
        }
        builder.append(name.trim() + " ");
        this.idnControlSubField = !this.ignoreRecordId && FIELD_IDN_INTERN.equals(name.trim());
        this.entityOpen = true;
    }

    public void literal(String name, String value) {
        if (name.length() != 1) {
            throw new FormatException(name);
        }
        if (!this.entityOpen) {
            throw new FormatException(name);
        }
        String valueNew = Normalizer.normalize(value, Normalizer.Form.NFD);
        if (this.idnControlSubField) {
            if (!this.id.equals(value)) {
                throw new MissingIdException(value);
            }
            this.idnControlSubField = false;
        }
        builder.append(SUB_DELIMITER);
        builder.append(name);
        builder.append(valueNew);
    }

    public void endEntity() {
        builder.append(FIELD_DELIMITER);
        this.entityOpen = false;
    }

    public void endRecord() {
        ((ObjectReceiver)this.getReceiver()).process((Object)builder.toString());
        this.entityOpen = false;
    }

    protected void onResetStream() {
        builder.setLength(0);
    }
}

