/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.pica;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.metafacture.flowcontrol.StreamBuffer;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.Receiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@In(value=StreamReceiver.class)
@Out(value=StreamReceiver.class)
@Description(value="Groups multiscript fields in entities")
@FluxCommand(value="remodel-pica-multiscript")
public final class PicaMultiscriptRemodeler
extends DefaultStreamPipe<StreamReceiver> {
    public static final String ENTITY_NAME_FOR_LATIN = "Latin";
    public static final String ENTITY_NAME_FOR_NON_LATIN_LR = "NonLatinLR";
    public static final String ENTITY_NAME_FOR_NON_LATIN_RL = "NonLatinRL";
    private static final BufferedField BEFORE_FIRST_FIELD = new BufferedField("", null);
    private static final String GROUP_SUBFIELD = "T";
    private static final String SCRIPT_SUBFIELD = "U";
    private static final String LATIN_SCRIPT = "Latn";
    private static final String ARABIC_SCRIPT = "Arab";
    private static final String HEBREW_SCRIPT = "Hebr";
    private BufferedField currentField;
    private BufferedField lastField;
    private final SortedMap<String, BufferedField> bufferedFields = new TreeMap<String, BufferedField>();

    public void startRecord(String identifier) {
        ((StreamReceiver)this.getReceiver()).startRecord(identifier);
        this.currentField = null;
        this.lastField = BEFORE_FIRST_FIELD;
        this.bufferedFields.clear();
    }

    public void endRecord() {
        this.emitAsSingleMultiscriptFields(this.bufferedFields);
        ((StreamReceiver)this.getReceiver()).endRecord();
    }

    public void startEntity(String name) {
        this.currentField = new BufferedField(name);
        this.currentField.getStream().setReceiver((Receiver)((StreamReceiver)this.getReceiver()));
        if (!this.lastField.getName().equals(this.currentField.getName())) {
            this.emitAsSingleMultiscriptFields(this.bufferedFields);
        }
    }

    public void endEntity() {
        if (this.currentField.getGroup() == null || this.currentField.getScript() == null) {
            this.emitNonMultiscriptField();
        } else if (this.bufferedFields.containsKey(this.currentField.getGroup())) {
            this.emitAsSingleMultiscriptFields(this.getSingleMultiscriptFieldsBeforeCurrentField());
            this.emitRemodeledMultiscriptField((BufferedField)this.bufferedFields.remove(this.currentField.getGroup()), this.currentField);
        } else {
            this.bufferMultiscriptField(this.currentField);
        }
        this.lastField = this.currentField;
        this.currentField = null;
    }

    public void literal(String name, String value) {
        this.currentField.getStream().literal(name, value);
        if (GROUP_SUBFIELD.equals(name)) {
            this.currentField.setGroup(value);
        } else if (SCRIPT_SUBFIELD.equals(name)) {
            this.currentField.setScript(value);
        }
    }

    private void bufferMultiscriptField(BufferedField field) {
        this.bufferedFields.put(field.getGroup(), field);
    }

    private Map<?, BufferedField> getSingleMultiscriptFieldsBeforeCurrentField() {
        return this.bufferedFields.headMap(this.currentField.getGroup());
    }

    private void emitNonMultiscriptField() {
        ((StreamReceiver)this.getReceiver()).startEntity(this.currentField.getName());
        this.currentField.getStream().replay();
        ((StreamReceiver)this.getReceiver()).endEntity();
    }

    private void emitRemodeledMultiscriptField(BufferedField firstField, BufferedField secondField) {
        ((StreamReceiver)this.getReceiver()).startEntity(firstField.getName());
        ((StreamReceiver)this.getReceiver()).startEntity(this.mapScriptToEntityName(firstField.getScript()));
        firstField.getStream().replay();
        ((StreamReceiver)this.getReceiver()).endEntity();
        ((StreamReceiver)this.getReceiver()).startEntity(this.mapScriptToEntityName(secondField.getScript()));
        secondField.getStream().replay();
        ((StreamReceiver)this.getReceiver()).endEntity();
        ((StreamReceiver)this.getReceiver()).endEntity();
    }

    private void emitAsSingleMultiscriptFields(Map<?, BufferedField> fields) {
        for (BufferedField field : fields.values()) {
            ((StreamReceiver)this.getReceiver()).startEntity(field.getName());
            field.getStream().replay();
            ((StreamReceiver)this.getReceiver()).endEntity();
        }
        fields.clear();
    }

    private String mapScriptToEntityName(String script) {
        return LATIN_SCRIPT.equals(script) ? ENTITY_NAME_FOR_LATIN : (ARABIC_SCRIPT.equals(script) || HEBREW_SCRIPT.equals(script) ? ENTITY_NAME_FOR_NON_LATIN_RL : ENTITY_NAME_FOR_NON_LATIN_LR);
    }

    private static class BufferedField {
        private final String name;
        private final StreamBuffer stream;
        private String group = null;
        private String script = null;

        BufferedField(String name) {
            this(name, new StreamBuffer());
        }

        BufferedField(String name, StreamBuffer stream) {
            this.name = name;
            this.stream = stream;
        }

        public String getName() {
            return this.name;
        }

        public StreamBuffer getStream() {
            return this.stream;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }
    }
}

