/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.pica;

import java.text.Normalizer;
import org.metafacture.framework.StreamReceiver;

final class PicaParserContext {
    private final StringBuilder builder = new StringBuilder();
    private boolean normalizeUTF8;
    private boolean skipEmptyFields = true;
    private boolean trimFieldNames = true;
    private StreamReceiver receiver;
    private String entityName;
    private boolean literalsEmitted;
    private String subfieldName;

    PicaParserContext() {
    }

    public void setNormalizeUTF8(boolean normalizeUTF8) {
        this.normalizeUTF8 = normalizeUTF8;
    }

    public boolean getNormalizeUTF8() {
        return this.normalizeUTF8;
    }

    public void setSkipEmptyFields(boolean skipEmptyFields) {
        this.skipEmptyFields = skipEmptyFields;
    }

    public boolean getSkipEmptyFields() {
        return this.skipEmptyFields;
    }

    public void setTrimFieldNames(boolean trimFieldNames) {
        this.trimFieldNames = trimFieldNames;
    }

    public boolean getTrimFieldNames() {
        return this.trimFieldNames;
    }

    public void setReceiver(StreamReceiver receiver) {
        this.receiver = receiver;
    }

    public void reset() {
        this.getTextAndReset();
        this.entityName = null;
        this.literalsEmitted = false;
        this.subfieldName = null;
    }

    protected void appendText(char ch) {
        this.builder.append(ch);
    }

    protected void emitStartEntity() {
        this.entityName = this.getTextAndReset();
        if (this.trimFieldNames) {
            this.entityName = this.entityName.trim();
        }
        this.literalsEmitted = false;
    }

    protected void emitEndEntity() {
        if (!this.literalsEmitted) {
            if (this.skipEmptyFields || this.entityName.isEmpty()) {
                return;
            }
            this.receiver.startEntity(this.entityName);
            this.entityName = null;
        }
        this.receiver.endEntity();
    }

    protected void setSubfieldName(char name) {
        this.subfieldName = String.valueOf(name);
    }

    protected void emitLiteral() {
        assert (this.subfieldName != null);
        assert (this.entityName != null || this.literalsEmitted);
        if (this.entityName != null) {
            this.receiver.startEntity(this.entityName);
            this.entityName = null;
            this.literalsEmitted = true;
        }
        String value = this.getTextAndReset();
        if (this.normalizeUTF8) {
            value = Normalizer.normalize(value, Normalizer.Form.NFC);
        }
        this.receiver.literal(this.subfieldName, value);
        this.subfieldName = null;
    }

    private String getTextAndReset() {
        String text = this.builder.toString();
        this.builder.setLength(0);
        return text;
    }
}

