/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.pica;

import org.metafacture.biblio.pica.PicaConstants;
import org.metafacture.biblio.pica.PicaParserContext;

enum PicaParserState {
    FIELD_NAME{

        @Override
        protected PicaParserState parseChar(char ch, PicaParserContext ctx, boolean normalized) {
            PicaParserState next;
            switch (PicaConstants.from(normalized, ch)) {
                case RECORD_MARKER: 
                case FIELD_MARKER: 
                case FIELD_END_MARKER: {
                    ctx.emitStartEntity();
                    ctx.emitEndEntity();
                    next = FIELD_NAME;
                    break;
                }
                case SUBFIELD_MARKER: {
                    ctx.emitStartEntity();
                    next = SUBFIELD_NAME;
                    break;
                }
                default: {
                    ctx.appendText(ch);
                    next = this;
                }
            }
            return next;
        }

        @Override
        protected void endOfInput(PicaParserContext ctx) {
            ctx.emitStartEntity();
            ctx.emitEndEntity();
        }
    }
    ,
    SUBFIELD_NAME{

        @Override
        protected PicaParserState parseChar(char ch, PicaParserContext ctx, boolean normalized) {
            PicaParserState next;
            switch (PicaConstants.from(normalized, ch)) {
                case RECORD_MARKER: 
                case FIELD_MARKER: 
                case FIELD_END_MARKER: {
                    ctx.emitEndEntity();
                    next = FIELD_NAME;
                    break;
                }
                case SUBFIELD_MARKER: {
                    next = this;
                    break;
                }
                default: {
                    ctx.setSubfieldName(ch);
                    next = SUBFIELD_VALUE;
                }
            }
            return next;
        }

        @Override
        protected void endOfInput(PicaParserContext ctx) {
            ctx.emitEndEntity();
        }
    }
    ,
    SUBFIELD_VALUE{

        @Override
        protected PicaParserState parseChar(char ch, PicaParserContext ctx, boolean normalized) {
            PicaParserState next;
            switch (PicaConstants.from(normalized, ch)) {
                case RECORD_MARKER: 
                case FIELD_MARKER: 
                case FIELD_END_MARKER: {
                    ctx.emitLiteral();
                    ctx.emitEndEntity();
                    next = FIELD_NAME;
                    break;
                }
                case SUBFIELD_MARKER: {
                    ctx.emitLiteral();
                    next = SUBFIELD_NAME;
                    break;
                }
                default: {
                    ctx.appendText(ch);
                    next = this;
                }
            }
            return next;
        }

        @Override
        protected void endOfInput(PicaParserContext ctx) {
            ctx.emitLiteral();
            ctx.emitEndEntity();
        }
    };


    protected abstract PicaParserState parseChar(char var1, PicaParserContext var2, boolean var3);

    protected abstract void endOfInput(PicaParserContext var1);
}

