/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.biblio.pica;

import java.text.Normalizer;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.XmlReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultXmlPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Description(value="A pica xml reader")
@In(value=XmlReceiver.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="handle-picaxml")
public final class PicaXmlHandler
extends DefaultXmlPipe<StreamReceiver> {
    private static final String SUBFIELD = "subf";
    private static final String DATAFIELD = "tag";
    private static final String RECORD = "record";
    private static final String NAMESPACE = "http://www.oclcpica.org/xmlns/ppxml-1.0";
    private static final String LEADER = "global";
    private String currentTag = "";
    private StringBuilder builder = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (SUBFIELD.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = attributes.getValue("id");
        } else if (DATAFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).startEntity(attributes.getValue("id") + attributes.getValue("occ"));
        } else if (RECORD.equals(localName) && NAMESPACE.equals(uri)) {
            ((StreamReceiver)this.getReceiver()).startRecord("");
        } else if (LEADER.equals(localName)) {
            this.builder = new StringBuilder();
            this.currentTag = LEADER;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (SUBFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).literal(this.currentTag, Normalizer.normalize(this.builder.toString().trim(), Normalizer.Form.NFC));
        } else if (DATAFIELD.equals(localName)) {
            ((StreamReceiver)this.getReceiver()).endEntity();
        } else if (RECORD.equals(localName) && NAMESPACE.equals(uri)) {
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.builder.append(chars, start, length);
    }
}

