/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.csv;

import com.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Decodes lines of CSV files. First line may be interpreted as header.")
@In(value=String.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="decode-csv")
public final class CsvDecoder
extends DefaultObjectPipe<String, StreamReceiver> {
    public static final char DEFAULT_SEP = ',';
    private char separator = (char)44;
    private String[] header = new String[0];
    private int count;
    private boolean hasHeader;

    public CsvDecoder(String separator) {
        this.separator = separator.charAt(0);
    }

    public CsvDecoder(char separator) {
        this.separator = separator;
    }

    public CsvDecoder() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(String string) {
        assert (!this.isClosed());
        String[] parts = this.parseCsv(string);
        if (this.hasHeader) {
            if (this.header.length == 0) {
                this.header = parts;
                return;
            } else {
                if (parts.length != this.header.length) throw new IllegalArgumentException(String.format("wrong number of columns (expected %s, was %s) in input line: %s", this.header.length, parts.length, string));
                ((StreamReceiver)this.getReceiver()).startRecord(String.valueOf(++this.count));
                for (int i = 0; i < parts.length; ++i) {
                    ((StreamReceiver)this.getReceiver()).literal(this.header[i], parts[i]);
                }
                ((StreamReceiver)this.getReceiver()).endRecord();
            }
            return;
        } else {
            ((StreamReceiver)this.getReceiver()).startRecord(String.valueOf(++this.count));
            for (int i = 0; i < parts.length; ++i) {
                ((StreamReceiver)this.getReceiver()).literal(String.valueOf(i), parts[i]);
            }
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
    }

    private String[] parseCsv(String string) {
        String[] parts = new String[]{};
        try {
            CSVReader reader = new CSVReader((Reader)new StringReader(string), this.separator);
            List lines = reader.readAll();
            if (lines.size() > 0) {
                parts = (String[])lines.get(0);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return parts;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public void setSeparator(String separator) {
        this.separator = separator.charAt(0);
    }
}

