/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.csv;

import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Encodes each value in a record as a csv row.")
@In(value=StreamReceiver.class)
@Out(value=String.class)
@FluxCommand(value="encode-csv")
public class CsvEncoder
extends DefaultStreamPipe<ObjectReceiver<String>> {
    public static final char DEFAULT_SEP = ',';
    private CSVWriter csvWriter;
    private StringWriter writer;
    private List<String> rowItems = new ArrayList<String>();
    private boolean isFirstRecord = true;
    private List<String> header = new ArrayList<String>();
    private char separator = (char)44;
    private boolean noQuotes;
    private boolean includeHeader;
    private boolean includeRecordId;

    public CsvEncoder(String separator) {
        this.separator = separator.charAt(0);
    }

    public CsvEncoder(char separator) {
        this.separator = separator;
    }

    public CsvEncoder() {
    }

    public void setIncludeRecordId(boolean includeRecordId) {
        this.includeRecordId = includeRecordId;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    public void setSeparator(String separator) {
        if (separator.length() > 1) {
            throw new MetafactureException("Separator needs to be a single character.");
        }
        this.separator = separator.charAt(0);
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setNoQuotes(boolean noQuotes) {
        this.noQuotes = noQuotes;
    }

    private void initialize() {
        this.writer = new StringWriter();
        String emptyLineEnd = "";
        this.csvWriter = new CSVWriter((Writer)this.writer, this.separator, this.noQuotes ? (char)'\u0000' : '\"', '\"', "");
    }

    private String[] arrayOf(List<String> list) {
        int length = list.size();
        return list.toArray(new String[length]);
    }

    private void resetCaches() {
        this.rowItems = new ArrayList<String>();
    }

    private void writeRow(List<String> rowItemsArray) {
        String[] row = this.arrayOf(rowItemsArray);
        this.csvWriter.writeNext(row);
        String line = this.writer.toString();
        ((ObjectReceiver)this.getReceiver()).process((Object)line);
        this.writer.getBuffer().setLength(0);
    }

    public void startRecord(String identifier) {
        if (this.isFirstRecord) {
            this.initialize();
            if (this.includeRecordId) {
                this.header.add("record id");
            }
        }
        this.rowItems = new ArrayList<String>();
        if (this.includeRecordId) {
            this.rowItems.add(identifier);
        }
    }

    public void endRecord() {
        if (this.isFirstRecord) {
            if (this.includeHeader) {
                this.writeRow(this.header);
                this.header.clear();
            }
            this.isFirstRecord = false;
        }
        this.writeRow(this.rowItems);
        this.resetCaches();
    }

    public void literal(String name, String value) {
        if (this.isFirstRecord) {
            this.header.add(name);
        }
        this.rowItems.add(value);
    }

    public void onCloseStream() {
        try {
            this.csvWriter.close();
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    public void onResetStream() {
        this.includeRecordId = false;
        this.includeHeader = false;
        this.header = new ArrayList<String>();
        this.isFirstRecord = true;
        this.rowItems = new ArrayList<String>();
    }
}

