/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.files;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@In(value=String.class)
@Out(value=String.class)
@Description(value="Reads a directory and emits all filenames found.")
@FluxCommand(value="read-dir")
public final class DirReader
extends DefaultObjectPipe<String, ObjectReceiver<String>> {
    private boolean recursive;
    private String filenameFilterPattern;

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setFilenamePattern(String newFilenameFilterPattern) {
        this.filenameFilterPattern = newFilenameFilterPattern;
    }

    public void process(String dir) {
        File file = new File(dir);
        if (file.isDirectory()) {
            this.dir(file);
        } else {
            ((ObjectReceiver)this.getReceiver()).process((Object)dir);
        }
    }

    private void dir(File dir) {
        ObjectReceiver receiver = (ObjectReceiver)this.getReceiver();
        Object[] files = this.filenameFilterPattern == null ? dir.listFiles() : dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(DirReader.this.filenameFilterPattern);
            }
        });
        Arrays.sort(files);
        for (Object file : files) {
            if (((File)file).isDirectory()) {
                if (!this.recursive) continue;
                this.dir((File)file);
                continue;
            }
            receiver.process((Object)((File)file).getAbsolutePath());
        }
    }
}

