/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.files;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;

@Description(value="Uses the input string as a file name and computes a cryptographic hash the file")
@In(value=String.class)
@Out(value=Triple.class)
@FluxCommand(value="digest-file")
public final class FileDigestCalculator
extends DefaultObjectPipe<String, ObjectReceiver<Triple>> {
    private static final int BUFFER_SIZE = 1024;
    private static final int HIGH_NIBBLE = 240;
    private static final int LOW_NIBBLE = 15;
    private static final char[] NIBBLE_TO_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int NIBBLE_TO_HEX_SHIFT_WIDTH = 4;
    private final DigestAlgorithm algorithm;
    private final MessageDigest messageDigest;

    public FileDigestCalculator(DigestAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.messageDigest = this.algorithm.getInstance();
    }

    public FileDigestCalculator(String algorithm) {
        this.algorithm = DigestAlgorithm.valueOf(algorithm.toUpperCase());
        this.messageDigest = this.algorithm.getInstance();
    }

    public void process(String file) {
        String digest;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            digest = FileDigestCalculator.bytesToHex(FileDigestCalculator.getDigest(stream, this.messageDigest));
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
        ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(file, this.algorithm.name(), digest));
    }

    private static byte[] getDigest(InputStream stream, MessageDigest messageDigest) throws IOException {
        byte[] buffer = new byte[1024];
        int read = stream.read(buffer, 0, 1024);
        while (read > -1) {
            messageDigest.update(buffer, 0, read);
            read = stream.read(buffer, 0, 1024);
        }
        return messageDigest.digest();
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hex = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            hex[i * 2] = NIBBLE_TO_HEX[(bytes[i] & 0xF0) >>> 4];
            hex[i * 2 + 1] = NIBBLE_TO_HEX[bytes[i] & 0xF];
        }
        return new String(hex);
    }

    public static enum DigestAlgorithm {
        MD2("MD2"),
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private final String identifier;

        private DigestAlgorithm(String identifier) {
            this.identifier = identifier;
        }

        public MessageDigest getInstance() {
            try {
                return MessageDigest.getInstance(this.identifier);
            }
            catch (NoSuchAlgorithmException e) {
                throw new MetafactureException((Throwable)e);
            }
        }
    }
}

