/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.flux;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.commons.reflection.ObjectFactory;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.annotations.ReturnsAvailableArguments;

public final class HelpPrinter {
    private HelpPrinter() {
    }

    public static void print(ObjectFactory<?> factory, PrintStream out) {
        out.println("Welcome to Metafacture");
        out.println("======================");
        out.println();
        out.println(HelpPrinter.getVersionInfo());
        out.println("\nUsage:\tflux FLOW_FILE [VARNAME=VALUE ...]\n");
        out.println("Available flux commands:\n");
        ArrayList keyWords = new ArrayList();
        keyWords.addAll(factory.keySet());
        Collections.sort(keyWords);
        for (String name : keyWords) {
            HelpPrinter.describe(name, factory, out);
        }
    }

    private static String getVersionInfo() {
        try {
            return ResourceUtil.loadProperties((String)"build.properties").toString();
        }
        catch (IOException e) {
            throw new MetafactureException("Failed to load build infos", (Throwable)e);
        }
    }

    private static <T> void describe(String name, ObjectFactory<T> factory, PrintStream out) {
        Out outClass;
        Map attributes;
        Collection<String> arguments;
        Class moduleClass = factory.get(name).getPlainClass();
        Description desc = moduleClass.getAnnotation(Description.class);
        out.println(name);
        name.chars().forEach(c -> out.print("-"));
        out.println();
        if (desc != null) {
            out.println("- description:\t" + desc.value());
        }
        if (!(arguments = HelpPrinter.getAvailableArguments(moduleClass)).isEmpty()) {
            out.println("- arguments:\t" + arguments);
        }
        if (!(attributes = factory.get(name).getSetterTypes()).isEmpty()) {
            out.print("- options:\t");
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : attributes.entrySet()) {
                if (((Class)entry.getValue()).isEnum()) {
                    builder.append((String)entry.getKey()).append(" ").append(Arrays.asList(((Class)entry.getValue()).getEnumConstants())).append(", ");
                    continue;
                }
                builder.append((String)entry.getKey()).append(" (").append(((Class)entry.getValue()).getSimpleName()).append("), ");
            }
            out.println(builder.substring(0, builder.length() - 2));
        }
        String inString = "<unknown>";
        String outString = "";
        In inClass = moduleClass.getAnnotation(In.class);
        if (inClass != null) {
            inString = inClass.value().getSimpleName();
        }
        if ((outClass = moduleClass.getAnnotation(Out.class)) != null) {
            outString = outClass.value().getSimpleName();
        }
        out.println("- signature:\t" + inString + " -> " + outString);
        out.println("- java class:\t" + moduleClass.getCanonicalName());
        out.println();
    }

    private static Collection<String> getAvailableArguments(Class<?> moduleClass) {
        for (Method method : moduleClass.getMethods()) {
            if (method.getAnnotation(ReturnsAvailableArguments.class) == null) continue;
            try {
                return (Collection)method.invoke(moduleClass, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }
}

