/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.flux;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.commons.reflection.ConfigurableClass;
import org.metafacture.commons.reflection.ObjectFactory;
import org.metafacture.flux.parser.FluxProgramm;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.annotations.ReturnsAvailableArguments;

public final class HelpPrinter {
    public static final String PATH_TO_EXAMPLES = "../metafacture-documentation/linksAndExamples.tsv";
    private static final Map<String, String[]> EXAMPLES_MAP = new HashMap<String, String[]>();

    private HelpPrinter() {
    }

    public static void main(String[] args) throws IOException {
        FluxProgramm.printHelp(System.out);
    }

    public static void print(ObjectFactory<?> factory, PrintStream out) throws IOException {
        out.println("Welcome to Metafacture");
        out.println("======================");
        out.println();
        out.println(HelpPrinter.getVersionInfo());
        out.println("\nUsage:\tflux FLOW_FILE [VARNAME=VALUE ...]\n");
        out.println("Available flux commands:\n");
        ArrayList keyWords = new ArrayList(factory.keySet());
        Collections.sort(keyWords);
        HelpPrinter.loadExamples();
        for (String name : keyWords) {
            HelpPrinter.describe(name, factory, out);
        }
    }

    private static String getVersionInfo() {
        try {
            return ResourceUtil.loadProperties((String)"build.properties").toString();
        }
        catch (IOException e) {
            throw new MetafactureException("Failed to load build infos", (Throwable)e);
        }
    }

    private static <T> void describe(String name, ObjectFactory<T> factory, PrintStream out) {
        Collection<String> arguments;
        ConfigurableClass configurableClass = factory.get(name);
        Class moduleClass = configurableClass.getPlainClass();
        Description desc = moduleClass.getAnnotation(Description.class);
        out.println(name);
        name.chars().forEach(c -> out.print("-"));
        out.println();
        if (desc != null) {
            out.println("- description:\t" + desc.value());
        }
        if (!(arguments = HelpPrinter.getAvailableArguments(moduleClass)).isEmpty()) {
            out.println("- arguments:\t" + arguments);
        }
        HelpPrinter.printAttributes(out, configurableClass, configurableClass.getSetters());
        HelpPrinter.printSignature(out, moduleClass);
        String[] examplesEntry = EXAMPLES_MAP.get(name);
        if (examplesEntry != null && examplesEntry.length > 2) {
            out.println("- [example in Playground](" + examplesEntry[2] + ")");
        }
        if (examplesEntry != null && examplesEntry.length > 1) {
            out.println("- java class:\t[" + moduleClass.getCanonicalName() + "](" + examplesEntry[1] + ")");
        } else {
            out.println("- java class:\t" + moduleClass.getCanonicalName());
        }
        out.println();
    }

    private static <T> void printSignature(PrintStream out, Class<? extends T> moduleClass) {
        Out outClass;
        String inString = "<unknown>";
        String outString = "";
        In inClass = moduleClass.getAnnotation(In.class);
        if (inClass != null) {
            inString = inClass.value().getSimpleName();
        }
        if ((outClass = moduleClass.getAnnotation(Out.class)) != null) {
            outString = outClass.value().getSimpleName();
        }
        out.println("- signature:\t" + inString + " -> " + outString);
    }

    private static <T> void printAttributes(PrintStream out, ConfigurableClass<? extends T> configurableClass, Map<String, Method> attributes) {
        if (!attributes.isEmpty()) {
            out.print("- options:\t");
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, Method> entry : attributes.entrySet()) {
                Method method = entry.getValue();
                Class type = configurableClass.getSetterType(method);
                if (method.isAnnotationPresent(Deprecated.class)) {
                    builder.append("[deprecated] ");
                }
                if (type.isEnum()) {
                    builder.append(entry.getKey()).append(" ").append(Arrays.asList(type.getEnumConstants())).append(", ");
                    continue;
                }
                builder.append(entry.getKey()).append(" (").append(type.getSimpleName()).append("), ");
            }
            out.println(builder.substring(0, builder.length() - 2));
        }
    }

    private static Collection<String> getAvailableArguments(Class<?> moduleClass) {
        for (Method method : moduleClass.getMethods()) {
            if (method.getAnnotation(ReturnsAvailableArguments.class) == null) continue;
            try {
                return (Collection)method.invoke(moduleClass, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private static void loadExamples() throws IOException {
        File f = new File(PATH_TO_EXAMPLES);
        if (f.exists()) {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(f));
            while ((line = bufferedReader.readLine()) != null) {
                String[] tsv = line.split("\t");
                EXAMPLES_MAP.put(tsv[0], tsv);
                if (tsv.length >= 2) continue;
                System.err.println("Invalid command info: " + line);
            }
        }
    }
}

