/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.flux.parser;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.metafacture.flux.FluxParseException;
import org.metafacture.flux.parser.StringSender;
import org.metafacture.framework.LifeCycle;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.Receiver;
import org.metafacture.framework.Sender;
import org.metafacture.framework.Tee;
import org.metafacture.io.StdInOpener;

final class Flow {
    private final Deque<Tee<?>> teeStack = new LinkedList();
    private final Deque<List<LifeCycle>> looseEndsStack = new LinkedList<List<LifeCycle>>();
    private LifeCycle element;
    private ObjectReceiver<? extends Object> start;
    private boolean joinLooseEnds;

    Flow() {
    }

    public void addElement(Receiver nextElement) {
        if (this.element == null) {
            this.setStart((ObjectReceiver<? extends Object>)((ObjectReceiver)nextElement));
            return;
        }
        if (this.element instanceof Sender) {
            Sender sender = (Sender)this.element;
            if (this.joinLooseEnds) {
                this.teeStack.pop();
                for (LifeCycle looseEnd : this.looseEndsStack.pop()) {
                    if (looseEnd instanceof Tee) {
                        ((Tee)looseEnd).addReceiver(nextElement);
                        continue;
                    }
                    ((Sender)looseEnd).setReceiver(nextElement);
                }
                this.joinLooseEnds = false;
            } else if (sender instanceof Tee) {
                ((Tee)sender).addReceiver(nextElement);
            } else {
                sender.setReceiver(nextElement);
            }
        } else {
            throw new FluxParseException(this.element.getClass().getCanonicalName() + " is not a sender");
        }
        this.element = nextElement;
    }

    public void startTee() {
        if (!(this.element instanceof Tee)) {
            throw new FluxParseException("Flow cannot be split without a tee-element.");
        }
        Tee tee = (Tee)this.element;
        this.teeStack.push(tee);
        this.looseEndsStack.push(new ArrayList());
    }

    public void endTee() {
        this.joinLooseEnds = true;
    }

    public void endSubFlow() {
        this.looseEndsStack.peek().add(this.element);
        this.element = (LifeCycle)this.teeStack.peek();
    }

    private void setStart(ObjectReceiver<? extends Object> start) {
        this.start = start;
        this.element = start;
    }

    public void setStringStart(String string) {
        this.setStart((ObjectReceiver<? extends Object>)new StringSender(string));
    }

    public void setStdInStart() {
        this.setStart((ObjectReceiver<? extends Object>)new StdInOpener());
    }

    public void start() {
        this.start.process(null);
    }

    public void close() {
        this.start.closeStream();
    }

    public Receiver getFirst() {
        return this.start;
    }
}

