/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.flux.parser;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metafacture.commons.ResourceUtil;
import org.metafacture.commons.reflection.ConfigurableClass;
import org.metafacture.commons.reflection.ObjectFactory;
import org.metafacture.commons.reflection.ReflectionUtil;
import org.metafacture.flux.FluxParseException;
import org.metafacture.flux.HelpPrinter;
import org.metafacture.flux.parser.Flow;
import org.metafacture.framework.Receiver;

public final class FluxProgramm {
    private static final ObjectFactory<Receiver> COMMAND_FACTORY = new ObjectFactory();
    private static final String PROPERTIES_LOCATION = "flux-commands.properties";
    private Flow currentFlow = new Flow();
    private final List<Flow> initialFlows = new ArrayList<Flow>();
    private final Map<String, Wormhole> wormholeNameMapping = new HashMap<String, Wormhole>();
    private final Map<Flow, Wormhole> wormholeInFlowMapping = new Hashtable<Flow, Wormhole>();

    private static Receiver createElement(String name, Map<String, String> namedArgs, List<Object> cArgs) {
        Receiver newElement;
        if (COMMAND_FACTORY.containsKey(name)) {
            newElement = (Receiver)COMMAND_FACTORY.newInstance(name, namedArgs, cArgs.toArray());
        } else {
            ConfigurableClass elementClass = ReflectionUtil.loadClass((String)name, Receiver.class);
            newElement = (Receiver)elementClass.newInstance(namedArgs, cArgs.toArray());
        }
        return newElement;
    }

    protected void addElement(String name, Map<String, String> namedArgs, List<Object> cArgs) {
        this.currentFlow.addElement(FluxProgramm.createElement(name, namedArgs, cArgs));
    }

    protected void startTee() {
        this.currentFlow.startTee();
    }

    protected void endTee() {
        this.currentFlow.endTee();
    }

    protected void endSubFlow() {
        this.currentFlow.endSubFlow();
    }

    protected void setStringStart(String string) {
        this.currentFlow.setStringStart(string);
        if (!this.initialFlows.contains(this.currentFlow)) {
            this.initialFlows.add(this.currentFlow);
        }
    }

    protected void setStdInStart() {
        this.currentFlow.setStdInStart();
        if (!this.initialFlows.contains(this.currentFlow)) {
            this.initialFlows.add(this.currentFlow);
        }
    }

    protected void setWormholeEnd(String name) {
        Wormhole wormhole = this.wormholeNameMapping.get(name);
        if (wormhole == null) {
            wormhole = new Wormhole(name);
            this.wormholeNameMapping.put(name, wormhole);
        }
        wormhole.addIn(this.currentFlow);
        this.wormholeInFlowMapping.put(this.currentFlow, wormhole);
    }

    protected void setWormholeStart(String name) {
        Wormhole wormhole;
        if (this.initialFlows.contains(this.currentFlow)) {
            this.initialFlows.remove(this.currentFlow);
        }
        if ((wormhole = this.wormholeNameMapping.get(name)) == null) {
            wormhole = new Wormhole(name);
            this.wormholeNameMapping.put(name, wormhole);
        }
        wormhole.setOut(this.currentFlow);
    }

    protected void nextFlow() {
        this.currentFlow = new Flow();
    }

    protected void compile() {
        for (Wormhole wormhole : this.wormholeNameMapping.values()) {
            if (wormhole.getOut() == null) {
                throw new FluxParseException("Wormhole " + wormhole.getName() + " is going nowhere");
            }
            for (Flow flow : wormhole.getIns()) {
                flow.addElement(wormhole.getOut().getFirst());
            }
        }
    }

    public void start() {
        for (Flow flow : this.initialFlows) {
            flow.start();
            if (!this.wormholeInFlowMapping.containsKey(flow)) {
                flow.close();
                continue;
            }
            this.wormholeInFlowMapping.get(flow).finished(flow);
        }
    }

    public static void printHelp(PrintStream out) throws IOException {
        HelpPrinter.print(COMMAND_FACTORY, out);
    }

    static {
        try {
            Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources(PROPERTIES_LOCATION);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                COMMAND_FACTORY.loadClassesFromMap((Map)ResourceUtil.loadProperties((URL)url), Receiver.class);
            }
        }
        catch (IOException e) {
            throw new FluxParseException("unable to load properties.", e);
        }
    }

    private static final class Wormhole {
        private final Set<Flow> insReady = new HashSet<Flow>();
        private final Set<Flow> insFinished = new HashSet<Flow>();
        private Flow out;
        private final String name;

        Wormhole(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Flow getOut() {
            return this.out;
        }

        public Set<Flow> getIns() {
            return this.insReady;
        }

        public void setOut(Flow out) {
            this.out = out;
        }

        public void addIn(Flow flow) {
            this.insReady.add(flow);
        }

        public void finished(Flow flow) {
            this.insReady.remove(flow);
            this.insFinished.add(flow);
            if (this.insReady.isEmpty()) {
                for (Flow finished : this.insFinished) {
                    finished.close();
                }
            }
        }
    }
}

