/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formatting;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.commons.StringUtil;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;

@Description(value="Builds a String from a template and an Object. Provide template in brackets. `${o}` marks the place where the object is to be inserted. If the object is an instance of Triple `${s}`, `${p}` and `${o}` are used instead.")
@In(value=Object.class)
@Out(value=String.class)
@FluxCommand(value="template")
public final class ObjectTemplate<T>
extends DefaultObjectPipe<T, ObjectReceiver<String>> {
    private static final Pattern OBJ_PATTERN = Pattern.compile("${o}", 16);
    private final Map<String, String> vars = new HashMap<String, String>();
    private final String template;

    public ObjectTemplate(String template) {
        this.template = template;
    }

    public void process(T obj) {
        if (obj instanceof Triple) {
            Triple triple = (Triple)obj;
            this.vars.put("s", triple.getSubject());
            this.vars.put("p", triple.getPredicate());
            this.vars.put("o", triple.getObject());
            ((ObjectReceiver)this.getReceiver()).process((Object)StringUtil.format((String)this.template, this.vars));
        } else {
            Matcher matcher = OBJ_PATTERN.matcher(this.template);
            ((ObjectReceiver)this.getReceiver()).process((Object)matcher.replaceAll(obj.toString()));
        }
    }
}

