/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formatting;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Adds a String preamle and/or epilogue to the stream")
@In(value=String.class)
@Out(value=String.class)
@FluxCommand(value="add-preamble-epilogue")
public final class PreambleEpilogueAdder
extends DefaultObjectPipe<String, ObjectReceiver<String>> {
    private String preamble = "";
    private String epilogue = "";
    private boolean objectsReceived;

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void setEpilogue(String epilogue) {
        this.epilogue = epilogue;
    }

    public String getEpilogue() {
        return this.epilogue;
    }

    public void process(String obj) {
        if (!this.objectsReceived && !this.preamble.isEmpty()) {
            ((ObjectReceiver)this.getReceiver()).process((Object)this.preamble);
        }
        this.objectsReceived = true;
        ((ObjectReceiver)this.getReceiver()).process((Object)obj);
    }

    protected void onCloseStream() {
        if (this.objectsReceived && !this.epilogue.isEmpty()) {
            ((ObjectReceiver)this.getReceiver()).process((Object)this.epilogue);
        }
    }

    protected void onResetStream() {
        this.objectsReceived = false;
    }
}

