/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formatting;

import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Outputs the name and value of each literal which is received as a string. Name and value are separated by a separator string. The default separator string is a tab. If a literal name is empty, only the value will be output without a separator. The module ignores record and entity events. In particular, this means that literal names are not prefixed by the name of the entity which contains them.")
@In(value=StreamReceiver.class)
@Out(value=String.class)
@FluxCommand(value="encode-literals")
public final class StreamLiteralFormatter
extends DefaultStreamPipe<ObjectReceiver<String>> {
    public static final String DEFAULT_SEPARATOR = "\t";
    private String separator = "\t";

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void literal(String name, String value) {
        if (name == null || name.isEmpty()) {
            ((ObjectReceiver)this.getReceiver()).process((Object)value);
        } else {
            ((ObjectReceiver)this.getReceiver()).process((Object)(name + this.separator + value));
        }
    }
}

