/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.parser;

import org.metafacture.formeta.parser.StructureParserContext;
import org.metafacture.framework.FormatException;

enum StructureParserState {
    ITEM_NAME{

        @Override
        protected StructureParserState delimiterReached(char ch, StructureParserContext ctx) {
            StructureParserState newState;
            switch (ch) {
                case '{': {
                    ctx.startGroup();
                    newState = ITEM_NAME;
                    break;
                }
                case ':': {
                    ctx.startLiteral();
                    newState = LITERAL_VALUE;
                    break;
                }
                case ',': {
                    if (!ctx.isTextEmpty()) {
                        throw new FormatException(StructureParserState.getUnexpectedCharMsg(StructureParserState.NAME_DELIMITER_EXPECTED, ch));
                    }
                    newState = ITEM_NAME;
                    break;
                }
                case '}': {
                    if (!ctx.isTextEmpty() || !ctx.isNested()) {
                        throw new FormatException(StructureParserState.getUnexpectedCharMsg(StructureParserState.NAME_DELIMITER_EXPECTED, ch));
                    }
                    ctx.endGroup();
                    newState = ITEM_NAME;
                    break;
                }
                default: {
                    throw new FormatException(StructureParserState.getUnexpectedCharMsg(StructureParserState.NAME_DELIMITER_EXPECTED, ch));
                }
            }
            return newState;
        }

        @Override
        public void endOfInput(StructureParserContext ctx) {
            ctx.processEOIWithTextParser();
            if (!ctx.isTextEmpty() || ctx.isNested()) {
                throw new FormatException(StructureParserState.UNEXPECTED_EOI);
            }
        }
    }
    ,
    LITERAL_VALUE{

        @Override
        protected StructureParserState delimiterReached(char ch, StructureParserContext ctx) {
            StructureParserState newState;
            switch (ch) {
                case ',': {
                    ctx.endLiteral();
                    newState = ITEM_NAME;
                    break;
                }
                case '}': {
                    if (!ctx.isNested()) {
                        throw new FormatException(StructureParserState.getUnexpectedCharMsg(StructureParserState.ITEM_SEPARATOR_EXPECTED, ch));
                    }
                    ctx.endLiteral();
                    ctx.endGroup();
                    newState = ITEM_NAME;
                    break;
                }
                default: {
                    throw new FormatException(StructureParserState.getUnexpectedCharMsg(StructureParserState.VALUE_DELIMITER_EXPECTED, ch));
                }
            }
            return newState;
        }

        @Override
        public void endOfInput(StructureParserContext ctx) {
            ctx.processEOIWithTextParser();
            if (ctx.isNested()) {
                throw new FormatException(StructureParserState.UNEXPECTED_EOI);
            }
            ctx.endLiteral();
        }
    };

    private static final String NAME_DELIMITER_EXPECTED = "'{' or ':'";
    private static final String ITEM_SEPARATOR_EXPECTED = "','";
    private static final String VALUE_DELIMITER_EXPECTED = "'}' or ','";
    private static final String UNEXPECTED_EOI = "Unexpected end of input";

    public StructureParserState processChar(char ch, StructureParserContext ctx) {
        if (ctx.processCharWithTextParser(ch)) {
            return this.delimiterReached(ch, ctx);
        }
        return this;
    }

    public abstract void endOfInput(StructureParserContext var1);

    protected abstract StructureParserState delimiterReached(char var1, StructureParserContext var2);

    private static String getUnexpectedCharMsg(String expected, char actual) {
        return expected + " expected but got '" + actual + "'";
    }
}

