/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.parser;

import org.metafacture.formeta.Formeta;
import org.metafacture.formeta.parser.TextParserContext;
import org.metafacture.framework.FormatException;

enum TextParserState {
    LEADING_WHITESPACE{

        @Override
        public TextParserState processChar(char ch, TextParserContext ctx) {
            TextParserState newState;
            switch (ch) {
                case '\\': {
                    ctx.setQuoted(false);
                    newState = ESCAPE_SEQ;
                    break;
                }
                case '\'': {
                    ctx.setQuoted(true);
                    newState = QUOTED_TEXT;
                    break;
                }
                case ',': 
                case ':': 
                case '{': 
                case '}': {
                    ctx.setQuoted(false);
                    newState = DELIMITER_REACHED;
                    break;
                }
                default: {
                    if (Formeta.isWhitespace(ch)) {
                        newState = LEADING_WHITESPACE;
                        break;
                    }
                    ctx.setQuoted(false);
                    ctx.appendChar(ch);
                    newState = TEXT;
                }
            }
            return newState;
        }
    }
    ,
    TEXT{

        @Override
        public TextParserState processChar(char ch, TextParserContext ctx) {
            TextParserState newState;
            switch (ch) {
                case '\\': {
                    newState = ESCAPE_SEQ;
                    break;
                }
                case ',': 
                case ':': 
                case '{': 
                case '}': {
                    newState = DELIMITER_REACHED;
                    break;
                }
                default: {
                    ctx.appendChar(ch);
                    newState = TEXT;
                }
            }
            return newState;
        }
    }
    ,
    ESCAPE_SEQ{

        @Override
        public TextParserState processChar(char ch, TextParserContext ctx) {
            ctx.appendEscapedChar(ch);
            return TEXT;
        }

        @Override
        public void endOfInput(TextParserContext ctx) {
            throw new FormatException("incomplete escape sequence");
        }
    }
    ,
    QUOTED_TEXT{

        @Override
        public TextParserState processChar(char ch, TextParserContext ctx) {
            TextParserState newState;
            switch (ch) {
                case '\\': {
                    newState = QUOTED_ESCAPE_SEQ;
                    break;
                }
                case '\'': {
                    newState = TRAILING_WHITESPACE;
                    break;
                }
                default: {
                    ctx.appendChar(ch);
                    newState = QUOTED_TEXT;
                }
            }
            return newState;
        }

        @Override
        public void endOfInput(TextParserContext ctx) {
            throw new FormatException("quoted string is not terminated");
        }
    }
    ,
    QUOTED_ESCAPE_SEQ{

        @Override
        public TextParserState processChar(char ch, TextParserContext ctx) {
            ctx.appendEscapedChar(ch);
            return QUOTED_TEXT;
        }

        @Override
        public void endOfInput(TextParserContext ctx) {
            throw new FormatException("incomplete escape sequence and quoted string is not terminated");
        }
    }
    ,
    TRAILING_WHITESPACE{

        @Override
        public TextParserState processChar(char ch, TextParserContext ctx) {
            TextParserState newState;
            switch (ch) {
                case ',': 
                case ':': 
                case '{': 
                case '}': {
                    newState = DELIMITER_REACHED;
                    break;
                }
                default: {
                    if (Formeta.isWhitespace(ch)) {
                        newState = TRAILING_WHITESPACE;
                        break;
                    }
                    String sep = "', '";
                    String expected = "whitespace or one of '{', '}', ',', ':'";
                    throw new FormatException(TextParserState.getUnexpectedCharMsg("whitespace or one of '{', '}', ',', ':'", ch));
                }
            }
            return newState;
        }
    }
    ,
    DELIMITER_REACHED{

        @Override
        public TextParserState processChar(char ch, TextParserContext ctx) {
            throw new UnsupportedOperationException("Cannot process characters in state DELIMITER_REACHED");
        }
    };


    public abstract TextParserState processChar(char var1, TextParserContext var2);

    public void endOfInput(TextParserContext ctx) {
    }

    private static String getUnexpectedCharMsg(String expected, char actual) {
        return expected + " expected but got '" + actual + "'";
    }
}

