/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta;

import java.io.IOException;
import java.io.Reader;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@In(value=Reader.class)
@Out(value=String.class)
@Description(value="Reads a stream of formeta data and splits between each top-level element")
@FluxCommand(value="as-formeta-records")
public final class FormetaRecordsReader
extends DefaultObjectPipe<Reader, ObjectReceiver<String>> {
    private static final int BUFFER_SIZE = 0x1000000;
    private final StringBuilder builder = new StringBuilder();
    private final char[] buffer = new char[0x1000000];

    public void process(Reader reader) {
        assert (!this.isClosed());
        try {
            int size;
            boolean readSomething = false;
            boolean inQuotedText = false;
            int groupLevel = 0;
            while ((size = reader.read(this.buffer)) != -1) {
                readSomething = true;
                int offset = 0;
                block10: for (int i = 0; i < size; ++i) {
                    switch (this.buffer[i]) {
                        case '\\': {
                            ++i;
                            continue block10;
                        }
                        case '{': {
                            if (inQuotedText) continue block10;
                            ++groupLevel;
                            continue block10;
                        }
                        case '}': {
                            if (!inQuotedText) {
                                --groupLevel;
                            }
                        }
                        case ',': {
                            if (inQuotedText || groupLevel != 0) continue block10;
                            this.builder.append(this.buffer, offset, i - offset + 1);
                            offset = i + 1;
                            this.emitRecord();
                            continue block10;
                        }
                        case '\'': {
                            inQuotedText = !inQuotedText;
                            continue block10;
                        }
                    }
                }
                this.builder.append(this.buffer, offset, size - offset);
            }
            if (readSomething) {
                this.emitRecord();
            }
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private void emitRecord() {
        String record = this.builder.toString();
        ((ObjectReceiver)this.getReceiver()).process((Object)record);
        this.builder.delete(0, this.builder.length());
    }
}

