/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.formatter;

import org.metafacture.commons.StringUtil;
import org.metafacture.formeta.formatter.Formatter;

public abstract class AbstractFormatter
implements Formatter {
    public static final String CHARS_TO_ESCAPE_QUOTED = "\n\r'\\";
    public static final String CHARS_TO_ESCAPE = "\n\r'\\{},:";
    protected static final int BUFFER_SIZE = 1024;
    private final StringBuilder builder = new StringBuilder();
    private char[] buffer = new char[1024];

    @Override
    public final void reset() {
        this.builder.delete(0, this.builder.length());
        this.onReset();
    }

    public final String toString() {
        return this.builder.toString();
    }

    protected final void append(char ch) {
        this.builder.append(ch);
    }

    protected final void append(CharSequence charSeq) {
        this.builder.append(charSeq);
    }

    protected final void escapeAndAppend(String str) {
        this.buffer = StringUtil.copyToBuffer((String)str, (char[])this.buffer);
        int bufferLen = str.length();
        if (this.shouldQuoteText(this.buffer, bufferLen)) {
            this.builder.append('\'');
            for (int i = 0; i < bufferLen; ++i) {
                this.escapeAndAppendChar(this.buffer[i], CHARS_TO_ESCAPE_QUOTED);
            }
            this.builder.append('\'');
        } else {
            if (bufferLen > 0) {
                this.escapeAndAppendChar(this.buffer[0], "\n\r'\\{},:\t\n\r ");
            }
            for (int i = 1; i < bufferLen - 1; ++i) {
                this.escapeAndAppendChar(this.buffer[i], CHARS_TO_ESCAPE);
            }
            if (bufferLen > 1) {
                this.escapeAndAppendChar(this.buffer[bufferLen - 1], "\n\r'\\{},:\t\n\r ");
            }
        }
    }

    protected void onReset() {
    }

    protected abstract boolean shouldQuoteText(char[] var1, int var2);

    private void escapeAndAppendChar(char ch, String charsToEscape) {
        if (charsToEscape.indexOf(ch) > -1) {
            this.appendEscapedChar(ch);
        } else {
            this.builder.append(ch);
        }
    }

    private void appendEscapedChar(char ch) {
        this.builder.append('\\');
        switch (ch) {
            case '\n': {
                this.builder.append('n');
                break;
            }
            case '\r': {
                this.builder.append('r');
                break;
            }
            default: {
                this.builder.append(ch);
            }
        }
    }
}

