/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.formatter;

import org.metafacture.formeta.formatter.AbstractFormatter;

public final class ConciseFormatter
extends AbstractFormatter {
    private boolean appendItemSeparator;

    @Override
    public void startGroup(String name) {
        if (this.appendItemSeparator) {
            this.append(',');
        }
        this.escapeAndAppend(name);
        this.append('{');
        this.appendItemSeparator = false;
    }

    @Override
    public void endGroup() {
        this.append('}');
        this.appendItemSeparator = false;
    }

    @Override
    public void literal(String name, String value) {
        if (this.appendItemSeparator) {
            this.append(',');
        }
        this.escapeAndAppend(name);
        this.append(':');
        this.escapeAndAppend(value);
        this.appendItemSeparator = true;
    }

    @Override
    protected void onReset() {
        this.appendItemSeparator = false;
    }

    @Override
    protected boolean shouldQuoteText(char[] buffer, int len) {
        return len != 0 && ("\t\n\r ".indexOf(buffer[0]) > -1 || "\t\n\r ".indexOf(buffer[len - 1]) > -1);
    }
}

