/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.parser;

import org.metafacture.formeta.Formeta;
import org.metafacture.framework.FormatException;

class TextParserContext {
    private static final String ESCAPABLE_CHARS = "\t\n\r '\\{},:";
    private final StringBuilder text = new StringBuilder();
    private int lengthWithoutTrailingWs;
    private boolean quoted;

    TextParserContext() {
    }

    public String getText() {
        return this.text.substring(0, this.lengthWithoutTrailingWs);
    }

    public void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    public void appendChar(char ch) {
        this.text.append(ch);
        if (this.quoted || !Formeta.isWhitespace(ch)) {
            this.lengthWithoutTrailingWs = this.text.length();
        }
    }

    public void appendEscapedChar(char ch) {
        if ('n' == ch) {
            this.text.append('\n');
        } else if ('r' == ch) {
            this.text.append('\r');
        } else if (ESCAPABLE_CHARS.indexOf(ch) > -1) {
            this.text.append(ch);
        } else {
            throw new FormatException("invalid escape sequence: " + ch);
        }
        this.lengthWithoutTrailingWs = this.text.length();
    }

    public void reset() {
        this.text.delete(0, this.text.length());
        this.lengthWithoutTrailingWs = 0;
        this.quoted = false;
    }
}

