/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.framework.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.metafacture.framework.Receiver;
import org.metafacture.framework.Tee;

public class DefaultTee<T extends Receiver>
implements Tee<T> {
    private final List<T> receivers = new ArrayList<T>();

    @Override
    public final <R extends T> R setReceiver(R receiver) {
        this.receivers.clear();
        this.receivers.add(receiver);
        this.onChangeReceivers();
        return receiver;
    }

    @Override
    public final <R extends T> R setReceivers(R receiver, T lateralReceiver) {
        this.receivers.clear();
        this.receivers.add(receiver);
        this.receivers.add(lateralReceiver);
        this.onChangeReceivers();
        return receiver;
    }

    @Override
    public final Tee<T> addReceiver(T receiver) {
        this.receivers.add(receiver);
        this.onChangeReceivers();
        return this;
    }

    @Override
    public final Tee<T> removeReceiver(T receiver) {
        this.receivers.remove(receiver);
        this.onChangeReceivers();
        return this;
    }

    @Override
    public final Tee<T> clearReceivers() {
        this.receivers.clear();
        this.onChangeReceivers();
        return this;
    }

    @Override
    public final void resetStream() {
        this.onResetStream();
        for (Receiver receiver : this.receivers) {
            receiver.resetStream();
        }
    }

    @Override
    public final void closeStream() {
        this.onCloseStream();
        for (Receiver receiver : this.receivers) {
            receiver.closeStream();
        }
    }

    protected void onChangeReceivers() {
    }

    protected void onResetStream() {
    }

    protected void onCloseStream() {
    }

    protected final List<T> getReceivers() {
        return Collections.unmodifiableList(this.receivers);
    }
}

