/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.framework.objects;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;

public final class Triple
implements Comparable<Triple> {
    private final String subject;
    private final String predicate;
    private final String object;
    private final ObjectType objectType;
    private final int preCompHashCode;

    public Triple(String subject, String predicate, String object) {
        this(subject, predicate, object, ObjectType.STRING);
    }

    public Triple(String subject, String predicate, String object, ObjectType objectType) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.objectType = objectType;
        this.preCompHashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        return Objects.hash(new Object[]{this.subject, this.predicate, this.object, this.objectType});
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public String getObject() {
        return this.object;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public static Triple read(ObjectInputStream in) throws IOException {
        try {
            return new Triple(in.readUTF(), in.readUTF(), in.readUTF(), (ObjectType)((Object)in.readObject()));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot read triple", e);
        }
    }

    public void write(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.subject);
        out.writeUTF(this.predicate);
        out.writeUTF(this.object);
        out.writeObject((Object)this.objectType);
    }

    public int hashCode() {
        return this.preCompHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)obj;
        return other.preCompHashCode == this.preCompHashCode && other.predicate.equals(this.predicate) && other.object.equals(this.object) && other.subject.equals(this.subject) && other.objectType == this.objectType;
    }

    @Override
    public int compareTo(Triple triple) {
        int result = this.subject.compareTo(triple.subject);
        if (result == 0 && (result = this.predicate.compareTo(triple.predicate)) == 0 && (result = this.object.compareTo(triple.object)) == 0) {
            return this.objectType.compareTo(triple.objectType);
        }
        return result;
    }

    public String toString() {
        return this.subject + ":" + this.predicate + "=" + this.object + " (" + (Object)((Object)this.objectType) + ")";
    }

    public static enum ObjectType {
        STRING,
        ENTITY;

    }
}

