/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.html;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Extracts the specified element from an HTML document")
@In(value=Reader.class)
@Out(value=String.class)
@FluxCommand(value="extract-element")
public class ElementExtractor
extends DefaultObjectPipe<Reader, ObjectReceiver<String>> {
    private String selector;

    public ElementExtractor(String selector) {
        this.selector = selector;
    }

    public void process(Reader reader) {
        try {
            Document document = Jsoup.parse((String)IOUtils.toString((Reader)reader));
            Element firstElement = document.select(this.selector).first();
            ((ObjectReceiver)this.getReceiver()).process((Object)firstElement.data());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

