/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.input.BOMInputStream;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.io.FileCompression;

@Description(value="Opens a file.")
@In(value=String.class)
@Out(value=Reader.class)
@FluxCommand(value="open-file")
public final class FileOpener
extends DefaultObjectPipe<String, ObjectReceiver<Reader>> {
    private String encoding = "UTF-8";
    private FileCompression compression = FileCompression.AUTO;
    private boolean decompressConcatenated = false;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public FileCompression getCompression() {
        return this.compression;
    }

    public void setCompression(FileCompression compression) {
        this.compression = compression;
    }

    public void setCompression(String compression) {
        this.setCompression(FileCompression.valueOf(compression.toUpperCase()));
    }

    public boolean getDecompressConcatenated() {
        return this.decompressConcatenated;
    }

    public void setDecompressConcatenated(boolean decompressConcatenated) {
        this.decompressConcatenated = decompressConcatenated;
    }

    public void process(String file) {
        try {
            FileInputStream fileStream = new FileInputStream(file);
            try {
                InputStream decompressor = this.compression.createDecompressor(fileStream, this.decompressConcatenated);
                try {
                    InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(decompressor), this.encoding);
                    ((ObjectReceiver)this.getReceiver()).process((Object)reader);
                }
                catch (IOException | MetafactureException e) {
                    decompressor.close();
                    throw e;
                }
            }
            catch (IOException | MetafactureException e) {
                ((InputStream)fileStream).close();
                throw e;
            }
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }
}

