/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Processes input from a reader line by line.")
@In(value=Reader.class)
@Out(value=String.class)
@FluxCommand(value="as-lines")
public final class LineReader
extends DefaultObjectPipe<Reader, ObjectReceiver<String>> {
    private static final int BUFFER_SIZE = 0x1000000;

    public void process(Reader reader) {
        assert (!this.isClosed());
        assert (null != reader);
        LineReader.process(reader, (ObjectReceiver<String>)((ObjectReceiver)this.getReceiver()));
    }

    public static void process(Reader reader, ObjectReceiver<String> receiver) {
        BufferedReader lineReader = new BufferedReader(reader, 0x1000000);
        try {
            String line = lineReader.readLine();
            while (line != null) {
                receiver.process((Object)line);
                line = lineReader.readLine();
            }
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }
}

