/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.nio.charset.Charset;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.io.AbstractObjectWriter;
import org.metafacture.io.FileCompression;

@Description(value="Writes objects to stdout")
@In(value=Object.class)
@FluxCommand(value="print")
public final class ObjectStdoutWriter<T>
extends AbstractObjectWriter<T> {
    private static final String SET_COMPRESSION_ERROR = "Cannot compress standard out";
    private boolean firstObject = true;
    private boolean closed;

    @Override
    public String getEncoding() {
        return Charset.defaultCharset().toString();
    }

    @Override
    public void setEncoding(String encoding) {
        throw new UnsupportedOperationException("Cannot change encoding of standard out");
    }

    @Override
    public FileCompression getCompression() {
        return FileCompression.NONE;
    }

    @Override
    public void setCompression(FileCompression compression) {
        throw new UnsupportedOperationException(SET_COMPRESSION_ERROR);
    }

    @Override
    public void setCompression(String compression) {
        throw new UnsupportedOperationException(SET_COMPRESSION_ERROR);
    }

    public void process(T obj) {
        assert (!this.closed);
        if (this.firstObject) {
            System.out.print(this.getHeader());
            this.firstObject = false;
        } else {
            System.out.print(this.getSeparator());
        }
        System.out.print(obj);
    }

    public void resetStream() {
        this.firstObject = true;
    }

    public void closeStream() {
        if (!this.firstObject) {
            System.out.print(this.getFooter());
        }
        this.closed = true;
    }
}

