/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.annotations.ReturnsAvailableArguments;
import org.metafacture.io.ConfigurableObjectWriter;
import org.metafacture.io.FileCompression;
import org.metafacture.io.ObjectFileWriter;
import org.metafacture.io.ObjectStdoutWriter;

@Description(value="Writes objects to stdout or a file")
@In(value=Object.class)
@Out(value=Void.class)
@FluxCommand(value="write")
public final class ObjectWriter<T>
implements ConfigurableObjectWriter<T> {
    private static final String STDOUT = "stdout";
    private static final List<String> ARGUMENTS = Collections.unmodifiableList(Arrays.asList("stdout", "PATH"));
    private final ConfigurableObjectWriter<T> objectWriter;

    public ObjectWriter(String destination) {
        this.objectWriter = STDOUT.equals(destination) ? new ObjectStdoutWriter() : new ObjectFileWriter(destination);
    }

    @ReturnsAvailableArguments
    public static Collection<String> getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getEncoding() {
        return this.objectWriter.getEncoding();
    }

    @Override
    public void setEncoding(String encoding) {
        this.objectWriter.setEncoding(encoding);
    }

    @Override
    public FileCompression getCompression() {
        return this.objectWriter.getCompression();
    }

    @Override
    public void setCompression(FileCompression compression) {
        this.objectWriter.setCompression(compression);
    }

    @Override
    public void setCompression(String compression) {
        this.objectWriter.setCompression(compression);
    }

    @Override
    public String getHeader() {
        return this.objectWriter.getHeader();
    }

    @Override
    public void setHeader(String header) {
        this.objectWriter.setHeader(header);
    }

    @Override
    public String getFooter() {
        return this.objectWriter.getFooter();
    }

    @Override
    public void setFooter(String footer) {
        this.objectWriter.setFooter(footer);
    }

    @Override
    public String getSeparator() {
        return this.objectWriter.getSeparator();
    }

    @Override
    public void setSeparator(String separator) {
        this.objectWriter.setSeparator(separator);
    }

    public void process(T obj) {
        this.objectWriter.process(obj);
    }

    public void resetStream() {
        this.objectWriter.resetStream();
    }

    public void closeStream() {
        this.objectWriter.closeStream();
    }
}

