/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.annotations.In;
import org.metafacture.io.AbstractObjectWriter;
import org.metafacture.io.FileCompression;

@In(value=Object.class)
@FluxCommand(value="write-files")
public final class ObjectFileWriter<T>
extends AbstractObjectWriter<T> {
    private static final String VAR = "${i}";
    private static final Pattern VAR_PATTERN = Pattern.compile("${i}", 16);
    private String path;
    private int count;
    private Writer writer;
    private boolean firstObject;
    private boolean closed;
    private String encoding = "UTF-8";
    private FileCompression compression = FileCompression.AUTO;

    public ObjectFileWriter(String path) {
        this.path = path;
        this.startNewFile();
        Matcher matcher = VAR_PATTERN.matcher(this.path);
        if (!matcher.find()) {
            this.path = this.path + VAR;
        }
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public FileCompression getCompression() {
        return this.compression;
    }

    @Override
    public void setCompression(FileCompression compression) {
        this.compression = compression;
    }

    @Override
    public void setCompression(String compression) {
        this.setCompression(FileCompression.valueOf(compression.toUpperCase()));
    }

    public void process(T obj) {
        assert (!this.closed);
        try {
            if (this.firstObject) {
                this.writer.write(this.getHeader());
                this.firstObject = false;
            } else {
                this.writer.write(this.getSeparator());
            }
            this.writer.write(obj.toString());
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    public void resetStream() {
        if (!this.closed) {
            try {
                if (!this.firstObject) {
                    this.writer.write(this.getFooter());
                }
                this.writer.close();
            }
            catch (IOException e) {
                throw new MetafactureException((Throwable)e);
            }
            finally {
                this.closed = true;
            }
        }
        this.startNewFile();
        ++this.count;
    }

    public void closeStream() {
        if (!this.closed) {
            try {
                if (!this.firstObject) {
                    this.writer.write(this.getFooter());
                }
                this.writer.close();
            }
            catch (IOException e) {
                throw new MetafactureException((Throwable)e);
            }
            finally {
                this.closed = true;
            }
        }
    }

    private void startNewFile() {
        Matcher matcher = VAR_PATTERN.matcher(this.path);
        String currentPath = matcher.replaceAll(String.valueOf(this.count));
        try {
            FileOutputStream file = new FileOutputStream(currentPath);
            try {
                OutputStream compressor = this.compression.createCompressor(file, currentPath);
                try {
                    this.writer = new OutputStreamWriter(compressor, this.encoding);
                    this.firstObject = true;
                    this.closed = false;
                }
                catch (IOException e) {
                    compressor.close();
                    throw e;
                }
            }
            catch (IOException e) {
                ((OutputStream)file).close();
                throw e;
            }
        }
        catch (IOException e) {
            throw new MetafactureException("Error creating file '" + currentPath + "'.", (Throwable)e);
        }
    }
}

