/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.IOException;
import java.io.Reader;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Reads data from a Reader and splits it into individual records")
@In(value=Reader.class)
@Out(value=String.class)
@FluxCommand(value="as-records")
public final class RecordReader
extends DefaultObjectPipe<Reader, ObjectReceiver<String>> {
    public static final char DEFAULT_SEPARATOR = '\u001d';
    private static final int BUFFER_SIZE = 0x1000000;
    private final StringBuilder builder = new StringBuilder();
    private final char[] buffer = new char[0x1000000];
    private char separator = (char)29;
    private boolean skipEmptyRecords = true;

    public void setSeparator(String separator) {
        this.separator = separator.length() >= 1 ? separator.charAt(0) : (char)29;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSkipEmptyRecords(boolean skipEmptyRecords) {
        this.skipEmptyRecords = skipEmptyRecords;
    }

    public boolean getSkipEmptyRecords() {
        return this.skipEmptyRecords;
    }

    public void process(Reader reader) {
        assert (!this.isClosed());
        try {
            int size;
            boolean nothingRead = true;
            while ((size = reader.read(this.buffer)) != -1) {
                nothingRead = false;
                int offset = 0;
                for (int i = 0; i < size; ++i) {
                    if (this.buffer[i] != this.separator) continue;
                    this.builder.append(this.buffer, offset, i - offset);
                    offset = i + 1;
                    this.emitRecord();
                }
                this.builder.append(this.buffer, offset, size - offset);
            }
            if (!nothingRead) {
                this.emitRecord();
            }
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private void emitRecord() {
        String record = this.builder.toString();
        if (!this.skipEmptyRecords || !record.isEmpty()) {
            ((ObjectReceiver)this.getReceiver()).process((Object)record);
            this.builder.delete(0, this.builder.length());
        }
    }
}

