/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.input.ReaderInputStream;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;

@Description(value="Opens a tar archive and passes every entry.")
@In(value=Reader.class)
@Out(value=Reader.class)
@FluxCommand(value="open-tar")
public class TarReader
extends DefaultObjectPipe<Reader, ObjectReceiver<Reader>> {
    public void process(Reader reader) {
        try (ReaderInputStream stream = new ReaderInputStream(reader, Charset.defaultCharset());
             TarArchiveInputStream tarStream = new TarArchiveInputStream((InputStream)stream);){
            ArchiveEntry entry;
            while ((entry = tarStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                this.processFileEntry((ArchiveInputStream)tarStream);
            }
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private void processFileEntry(ArchiveInputStream archiveStream) throws IOException {
        try (ArchiveEntryInputStream entryStream = new ArchiveEntryInputStream(archiveStream);
             InputStreamReader entryReader = new InputStreamReader(entryStream);){
            ((ObjectReceiver)this.getReceiver()).process((Object)entryReader);
        }
    }

    private static class ArchiveEntryInputStream
    extends InputStream {
        private final ArchiveInputStream archiveStream;

        ArchiveEntryInputStream(ArchiveInputStream archiveStream) {
            this.archiveStream = archiveStream;
        }

        @Override
        public int read() throws IOException {
            return this.archiveStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.archiveStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.archiveStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.archiveStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.archiveStream.available();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void mark(int readlimit) {
            this.archiveStream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.archiveStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.archiveStream.markSupported();
        }
    }
}

