/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.util.HashMap;
import java.util.Map;
import org.metafacture.framework.MetafactureException;
import org.metafacture.javaintegration.pojo.ArrayTypeDecoder;
import org.metafacture.javaintegration.pojo.CollectionTypeDecoder;
import org.metafacture.javaintegration.pojo.ComplexTypeDecoder;
import org.metafacture.javaintegration.pojo.MapTypeDecoder;
import org.metafacture.javaintegration.pojo.MetafactureSourceTypeDecoder;
import org.metafacture.javaintegration.pojo.SimpleTypeDecoder;
import org.metafacture.javaintegration.pojo.TypeDecoder;

class TypeDecoderFactory {
    private final Map<Class<?>, TypeDecoder> typeDecoders = new HashMap();

    TypeDecoderFactory() {
    }

    TypeDecoder create(Class<?> clazz) {
        TypeDecoder typeDecoder;
        if (this.typeDecoders.containsKey(clazz)) {
            return this.typeDecoders.get(clazz);
        }
        if (SimpleTypeDecoder.supportsType(clazz)) {
            typeDecoder = new SimpleTypeDecoder();
        } else if (MetafactureSourceTypeDecoder.supportsType(clazz)) {
            typeDecoder = new MetafactureSourceTypeDecoder();
        } else if (CollectionTypeDecoder.supportsType(clazz)) {
            typeDecoder = new CollectionTypeDecoder(this);
        } else if (ArrayTypeDecoder.supportsType(clazz)) {
            typeDecoder = new ArrayTypeDecoder(this);
        } else if (ComplexTypeDecoder.supportsType(clazz)) {
            typeDecoder = new ComplexTypeDecoder(clazz, this);
        } else if (MapTypeDecoder.supportsType(clazz)) {
            typeDecoder = new MapTypeDecoder(this);
        } else {
            throw new MetafactureException("Can't decode type " + clazz);
        }
        this.typeDecoders.put(clazz, typeDecoder);
        return typeDecoder;
    }
}

