/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.metafacture.framework.MetafactureException;
import org.metafacture.javaintegration.pojo.ValueGetter;

class FieldValueGetter
implements ValueGetter {
    private final Field field;

    FieldValueGetter(Field field) {
        assert (FieldValueGetter.supportsField(field));
        this.field = field;
    }

    static boolean supportsField(Field f) {
        return Modifier.isPublic(f.getModifiers());
    }

    @Override
    public Object getValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new MetafactureException("The given object don't have a field named " + this.field.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MetafactureException("Can't access the field named " + this.field.getName(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getValueType() {
        return this.field.getType();
    }
}

