/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.javaintegration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.metafacture.framework.StreamReceiver;

public final class EventList
implements StreamReceiver {
    private final List<Event> events = new ArrayList<Event>();
    private boolean closed;

    public List<Event> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void startRecord(String identifier) {
        assert (!this.closed);
        this.events.add(new Event(Event.Type.START_RECORD, identifier));
    }

    public void endRecord() {
        assert (!this.closed);
        this.events.add(new Event(Event.Type.END_RECORD));
    }

    public void startEntity(String name) {
        assert (!this.closed);
        this.events.add(new Event(Event.Type.START_ENTITY, name));
    }

    public void endEntity() {
        assert (!this.closed);
        this.events.add(new Event(Event.Type.END_ENTITY));
    }

    public void literal(String name, String value) {
        assert (!this.closed);
        this.events.add(new Event(Event.Type.LITERAL, name, value));
    }

    public void resetStream() {
        this.closed = false;
        this.events.clear();
    }

    public void closeStream() {
        this.closed = true;
    }

    public static final class Event {
        private final Type type;
        private final String name;
        private final String value;

        Event(Type type) {
            this(type, null);
        }

        Event(Type type, String name) {
            this(type, name, null);
        }

        Event(Type type, String name, String value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append((Object)this.type);
            if (this.name != null) {
                builder.append("(");
                builder.append(this.name);
                if (this.value != null) {
                    builder.append("=");
                    builder.append(this.value);
                }
                builder.append(")");
            }
            return builder.toString();
        }

        public static enum Type {
            START_RECORD,
            END_RECORD,
            START_ENTITY,
            END_ENTITY,
            LITERAL;

        }
    }
}

